/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.matter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import matteroverdrive.api.matter.IMatterEntry;
import matteroverdrive.data.matter.IMatterEntryHandler;
import net.minecraft.nbt.NBTTagCompound;

public abstract class MatterEntryAbstract<KEY, MAT>
implements IMatterEntry<KEY, MAT> {
    protected final List<IMatterEntryHandler<MAT>> handlers = new ArrayList<IMatterEntryHandler<MAT>>();
    protected KEY key;

    public MatterEntryAbstract() {
    }

    public MatterEntryAbstract(KEY key) {
        this();
        this.key = key;
    }

    @Override
    public int getMatter(MAT key) {
        int matter = 0;
        for (IMatterEntryHandler<MAT> handler : this.handlers) {
            matter = handler.modifyMatter(key, matter);
            if (!handler.finalModification(key)) continue;
            return matter;
        }
        return matter;
    }

    public abstract void writeTo(DataOutput var1) throws IOException;

    public abstract void writeTo(NBTTagCompound var1);

    public abstract void readFrom(DataInput var1) throws IOException;

    public abstract void readFrom(NBTTagCompound var1);

    public abstract void readKey(String var1);

    public abstract String writeKey();

    public abstract boolean hasCached();

    @Override
    public void addHandler(IMatterEntryHandler<MAT> handler) {
        this.handlers.add(handler);
        Collections.sort(this.handlers);
    }

    public void clearHandlers() {
        this.handlers.clear();
    }

    public KEY getKey() {
        return this.key;
    }
}

