/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.matter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import matteroverdrive.data.matter.MatterEntryHandlerAbstract;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackHandlerCachable
extends MatterEntryHandlerAbstract<ItemStack> {
    private boolean metadataAware;
    private boolean isFinalHandler;
    private int meta;
    private int matter;
    private boolean custom;

    public ItemStackHandlerCachable() {
    }

    public ItemStackHandlerCachable(int matter) {
        this.matter = matter;
    }

    public ItemStackHandlerCachable(int matter, boolean isFinalHandler) {
        this.matter = matter;
        this.isFinalHandler = isFinalHandler;
    }

    public ItemStackHandlerCachable(int matter, int meta) {
        this(matter);
        this.meta = (short)meta;
        this.metadataAware = true;
    }

    public ItemStackHandlerCachable(int matter, int meta, boolean isFinalHandler) {
        this(matter, meta);
        this.isFinalHandler = isFinalHandler;
    }

    @Override
    public int modifyMatter(ItemStack itemStack, int originalMatter) {
        if (this.metadataAware) {
            if (itemStack.func_77952_i() == this.meta) {
                return this.matter;
            }
        } else {
            return this.matter;
        }
        return originalMatter;
    }

    @Override
    public boolean finalModification(ItemStack itemStack) {
        return false;
    }

    public void writeTo(DataOutput output) throws IOException {
        output.writeBoolean(this.metadataAware);
        output.writeBoolean(this.isFinalHandler);
        output.writeShort(this.meta);
        output.writeInt(this.matter);
        output.writeByte(this.priority);
    }

    public void writeTo(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("metaAware", this.metadataAware);
        tagCompound.func_74757_a("final", this.isFinalHandler);
        tagCompound.func_74777_a("meta", (short)this.meta);
        tagCompound.func_74768_a("matter", this.matter);
        tagCompound.func_74774_a("priority", (byte)this.priority);
    }

    public void readFrom(DataInput dataInput) throws IOException {
        this.metadataAware = dataInput.readBoolean();
        this.isFinalHandler = dataInput.readBoolean();
        this.meta = dataInput.readShort();
        this.matter = dataInput.readInt();
        this.priority = dataInput.readByte();
    }

    public void readFrom(NBTTagCompound tagCompound) {
        this.metadataAware = tagCompound.func_74767_n("metaAware");
        this.isFinalHandler = tagCompound.func_74767_n("final");
        this.meta = tagCompound.func_74765_d("meta");
        this.matter = tagCompound.func_74762_e("matter");
        this.priority = tagCompound.func_74771_c("priority");
    }

    public boolean isCustom() {
        return this.custom;
    }

    public ItemStackHandlerCachable markCustom() {
        this.custom = true;
        return this;
    }
}

