/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import java.util.EnumSet;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BioticStatNightVision
extends AbstractBioticStat
implements IConfigSubscriber {
    private static int ENERGY_PER_TICK = 16;

    public BioticStatNightVision(String name, int xp) {
        super(name, xp);
        this.setShowOnWheel(true);
        this.setShowOnHud(true);
    }

    @Override
    public String getDetails(int level) {
        return MOStringHelper.translateToLocal(this.getUnlocalizedDetails(), TextFormatting.YELLOW.toString() + ENERGY_PER_TICK + MOEnergyHelper.ENERGY_UNIT);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (!android.getPlayer().field_70170_p.field_72995_K) {
            if (this.isActive(android, level)) {
                // empty if block
            }
        } else {
            this.manageNightvision(android, level);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manageNightvision(AndroidPlayer android, int level) {
        if (this.isActive(android, level)) {
            android.getPlayer().func_70690_d(new PotionEffect(MobEffects.field_76439_r, 500));
        }
    }

    private void setActive(AndroidPlayer androidPlayer, int level, boolean active) {
        androidPlayer.getPlayer().func_70690_d(new PotionEffect(MobEffects.field_76439_r, 500));
        androidPlayer.getAndroidEffects().updateEffect(4, active);
        androidPlayer.sync(EnumSet.of(IAndroid.DataType.EFFECTS), true);
    }

    @Override
    public void onActionKeyPress(AndroidPlayer android, int level, boolean server) {
        if (this.equals(android.getActiveStat())) {
            if (server) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, android))) {
                    this.setActive(android, level, !android.getAndroidEffects().getEffectBool(4));
                }
            } else if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, android))) {
                this.playSound(android);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound(AndroidPlayer android) {
        if (!android.getAndroidEffects().getEffectBool(4)) {
            MOPositionedSound sound = new MOPositionedSound(MatterOverdriveSounds.androidNightVision, SoundCategory.PLAYERS, 0.05f + android.getPlayer().func_70681_au().nextFloat() * 0.1f, 0.95f + android.getPlayer().func_70681_au().nextFloat() * 0.1f);
            sound.setAttenuationType(ISound.AttenuationType.NONE);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        } else {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MOPositionedSound(MatterOverdriveSounds.androidPowerDown, SoundCategory.PLAYERS, 0.05f + android.getPlayer().func_70681_au().nextFloat() * 0.1f, 0.95f + android.getPlayer().func_70681_au().nextFloat() * 0.1f).setAttenuationType(ISound.AttenuationType.NONE));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (!this.isEnabled(androidPlayer, level) && this.isActive(androidPlayer, level)) {
            this.setActive(androidPlayer, level, false);
        }
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return androidPlayer.getAndroidEffects().getEffectBool(4);
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }

    @Override
    public boolean isEnabled(AndroidPlayer androidPlayer, int level) {
        return super.isEnabled(androidPlayer, level) && androidPlayer.hasEnoughEnergyScaled(ENERGY_PER_TICK);
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.isActive(android, level);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_TICK = config.getInt("nighvision_energy_per_tick", "abilities", 16, "The energy cost of the Nightvision");
    }
}

