/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class BioticStatInertialDampers
extends AbstractBioticStat {
    public BioticStatInertialDampers(String name, int xp) {
        super(name, xp);
        this.setMaxLevel(2);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
    }

    @Override
    public String getDetails(int level) {
        return MOStringHelper.translateToLocal(this.getUnlocalizedDetails(), TextFormatting.GREEN + DecimalFormat.getPercentInstance().format((float)level * 0.5f) + TextFormatting.GRAY);
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if (event instanceof LivingFallEvent) {
            ((LivingFallEvent)event).setDamageMultiplier(((LivingFallEvent)event).getDamageMultiplier() * Math.max(0.0f, 1.0f - (float)level * 0.5f));
            if ((int)((LivingFallEvent)event).getDistance() > 4) {
                androidPlayer.extractEnergyScaled((int)(((LivingFallEvent)event).getDistance() * (float)level * 0.5f));
            }
        }
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return super.isEnabled(android, level) && android.getEnergyStored() > 0;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return false;
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.isEnabled(android, level) && android.getPlayer().field_70143_R > 0.0f;
    }
}

