/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.Random;
import matteroverdrive.api.events.weapon.MOEventEnergyWeapon;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.client.render.HoloIcons;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingEvent;

public class BioticStatFlashCooling
extends AbstractBioticStat {
    private static final float COOLDOWN_CHANGE = 0.2f;
    private static final int ENERGY_PER_COOLDOWN = 1024;
    private final Random random = new Random();

    public BioticStatFlashCooling(String name, int xp) {
        super(name, xp);
    }

    @Override
    public String getDetails(int level) {
        return MOStringHelper.translateToLocal(this.getUnlocalizedDetails(), TextFormatting.GREEN + DecimalFormat.getPercentInstance().format(0.2f) + TextFormatting.GRAY, TextFormatting.YELLOW + 1024 + MOEnergyHelper.ENERGY_UNIT + TextFormatting.GRAY);
    }

    @Override
    public void registerIcons(TextureMap textureMap, HoloIcons holoIcons) {
        this.icon = holoIcons.getIcon("temperature");
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if (event instanceof MOEventEnergyWeapon.Overheat && this.random.nextFloat() < 0.2f) {
            event.setCanceled(true);
            ((MOEventEnergyWeapon.Overheat)event).energyWeapon.setHeat(((MOEventEnergyWeapon.Overheat)event).weaponStack, 0.0f);
            event.getEntity().field_70170_p.func_184148_a(null, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, MatterOverdriveSounds.weaponsOverheat, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return super.isEnabled(android, level) && android.getEnergyStored() > 0;
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return false;
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return android.getPlayer().func_184586_b(EnumHand.MAIN_HAND) != null && android.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon;
    }
}

