/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import java.text.DecimalFormat;
import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererAbstract;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StarMapRendererStar
extends StarMapRendererAbstract {
    public static IBakedModel star_model;

    public StarMapRendererStar() {
        try {
            IModel model = OBJLoader.INSTANCE.loadModel(new ResourceLocation("matteroverdrive:models/block/sphere.obj"));
            star_model = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, arg_0 -> ((TextureMap)Minecraft.func_71410_x().func_147117_R()).func_174942_a(arg_0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void renderBody(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float distance) {
        if (spaceBody instanceof Star) {
            GL11.glLineWidth((float)1.0f);
            Star star = (Star)spaceBody;
            this.random.setSeed(star.getSeed());
            double time = Minecraft.func_71410_x().field_71441_e.func_72820_D();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)star.getSize(), (float)star.getSize(), (float)star.getSize());
            ClientProxy.renderHandler.getRenderParticlesHandler().bindSheet();
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
            RenderUtils.tessalateParticle(Minecraft.func_71410_x().func_175606_aa(), this.star_icon, star.getSize(), new Vec3d(0.0, 0.0, 0.0), Reference.COLOR_HOLO_YELLOW.getFloatR() * 0.1f, Reference.COLOR_HOLO_YELLOW.getFloatG() * 0.1f, Reference.COLOR_HOLO_YELLOW.getFloatB() * 0.1f, Reference.COLOR_HOLO_YELLOW.getFloatA() * 0.1f);
            Tessellator.func_178181_a().func_78381_a();
            Color starColor = new Color(star.getColor()).multiplyWithoutAlpha(0.25f * (1.0f / distance));
            RenderUtils.applyColor(starColor);
            GL11.glPolygonMode((int)1028, (int)6913);
            GlStateManager.func_179090_x();
            double s = 0.2 + Math.sin(time * 0.01) * 0.01;
            GlStateManager.func_179139_a((double)s, (double)s, (double)s);
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176599_b);
            this.renderSphere(starColor.getColor());
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPolygonMode((int)1028, (int)6912);
            GL11.glPointSize((float)(10.0f / Math.max(3.0f, distance)));
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176599_b);
            this.renderSphere(starColor.getColor());
            Tessellator.func_178181_a().func_78381_a();
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176599_b);
            if (Minecraft.func_71410_x().field_71441_e.func_72820_D() % 120L > 80L) {
                float t = (float)(Minecraft.func_71410_x().field_71441_e.func_72820_D() % 120L - 80L) / 40.0f;
                s = MOMathHelper.easeIn(t, 0.0, 10.0, 1.0);
                GlStateManager.func_179139_a((double)(1.0 + s), (double)(1.0 + s), (double)(1.0 + s));
                this.renderSphere(starColor.multiplyWithoutAlpha(1.0f - t).getColor());
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
            GL11.glPolygonMode((int)1028, (int)6913);
            int planetID = 0;
            for (Planet planet : star.getPlanets()) {
                float sizeMultiply = 1.0f;
                if (starMap.getDestination().equals(planet)) {
                    sizeMultiply = 1.2f;
                }
                GlStateManager.func_179118_c();
                Color planetColor = Planet.getGuiColor(planet);
                this.random.setSeed(planet.getSeed());
                GlStateManager.func_179094_E();
                float axisRotation = this.random.nextInt(30) - 15;
                GlStateManager.func_179114_b((float)axisRotation, (float)1.0f, (float)0.0f, (float)0.0f);
                double radius = (double)(planet.getOrbit() * 2.0f) + ((double)(star.getSize() / 2.0f) + 0.1);
                float planetSize = planet.getSize();
                this.drawPlanetOrbit(planet, radius);
                GlStateManager.func_179137_b((double)(Math.sin(time * 0.001 + (double)(10 * planetID)) * radius), (double)0.0, (double)(Math.cos(time * 0.001 + (double)(10 * planetID)) * radius));
                GL11.glPolygonMode((int)1028, (int)6914);
                GlStateManager.func_179098_w();
                Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
                if (starMap.getDestination().equals(planet)) {
                    RenderUtils.tessalateParticle(Minecraft.func_71410_x().func_175606_aa(), this.selectedIcon, planet.getSize() * 0.15f * sizeMultiply, new Vec3d(0.0, 0.0, 0.0), planetColor);
                }
                if (starMap.getGalaxyPosition().equals(planet)) {
                    RenderUtils.tessalateParticle(Minecraft.func_71410_x().func_175606_aa(), this.currentIcon, planet.getSize() * 0.25f, new Vec3d(0.0, 0.0, 0.0), planetColor);
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(-axisRotation), (float)1.0f, (float)0.0f, (float)0.0f);
                RenderUtils.rotateTo(Minecraft.func_71410_x().func_175606_aa());
                this.drawPlanetInfo(planet);
                GlStateManager.func_179121_F();
                GL11.glPolygonMode((int)1028, (int)6913);
                GlStateManager.func_179090_x();
                RenderUtils.applyColorWithMultipy(planetColor, 0.3f * (1.0f / distance));
                GlStateManager.func_179114_b((float)100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)time * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                this.sphere.draw(planetSize * 0.1f * sizeMultiply, (int)(16.0f + planetSize * 2.0f), (int)(8.0f + planetSize * 2.0f));
                ++planetID;
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179098_w();
            GL11.glPolygonMode((int)1028, (int)6914);
        }
    }

    @Override
    public void renderGUIInfo(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float opacity) {
        if (spaceBody instanceof Star) {
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, opacity);
            GlStateManager.func_179141_d();
            Planet planet = galaxy.getPlanet(starMap.getDestination());
            if (planet != null) {
                if (GalaxyClient.getInstance().canSeePlanetInfo(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    RenderUtils.drawString(planet.getSpaceBodyName(), 72, -42, Reference.COLOR_HOLO, opacity);
                } else {
                    RenderUtils.drawString(Minecraft.func_71410_x().field_71464_q, planet.getSpaceBodyName(), 72, -42, Reference.COLOR_HOLO, opacity);
                }
                RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, opacity);
                ClientProxy.holoIcons.renderIcon("icon_size", 72.0, -28.0);
                RenderUtils.drawString(DecimalFormat.getPercentInstance().format(planet.getSize()), 92, -23, Reference.COLOR_HOLO, opacity);
                GlStateManager.func_179090_x();
                GL11.glPolygonMode((int)1032, (int)6914);
                this.random.setSeed(planet.getSeed());
                BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
                wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                for (int i = 0; i < 10; ++i) {
                    double step = 6.4;
                    double x = step * (double)i;
                    double y = -10.0;
                    double height = 64.0 * (0.5 * this.random.nextGaussian() + 1.0) / 2.0;
                    wr.func_181662_b(x, y, 0.0).func_181675_d();
                    wr.func_181662_b(x + step - 1.0, y, 0.0).func_181675_d();
                    wr.func_181662_b(x + step - 1.0, y - height, 0.0).func_181675_d();
                    wr.func_181662_b(x, y - height, 0.0).func_181675_d();
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179098_w();
            }
        }
    }

    @Override
    public boolean displayOnZoom(int zoom, SpaceBody spaceBody) {
        return true;
    }

    @Override
    public double getHologramHeight(SpaceBody spaceBody) {
        return 1.5;
    }

    private void drawPlanetInfo(Planet planet) {
        GlStateManager.func_179109_b((float)0.0f, (float)(planet.getSize() * 0.13f + 0.05f), (float)0.0f);
        GlStateManager.func_179139_a((double)0.005, (double)0.005, (double)0.005);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (GalaxyClient.getInstance().canSeePlanetInfo(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(planet.getSpaceBodyName());
            Minecraft.func_71410_x().field_71466_p.func_78276_b(planet.getSpaceBodyName(), -width / 2, 0, Planet.getGuiColor(planet).getColor());
            if (planet.isHomeworld((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                width = Minecraft.func_71410_x().field_71466_p.func_78256_a("[Home]");
                Minecraft.func_71410_x().field_71466_p.func_78276_b(TextFormatting.GOLD + "[Home]", -width / 2, -10, 0xFFFFFF);
            }
        } else {
            EntityPlayer owner;
            int width = Minecraft.func_71410_x().field_71464_q.func_78256_a(planet.getSpaceBodyName());
            Minecraft.func_71410_x().field_71464_q.func_78276_b(planet.getSpaceBodyName(), -width / 2, 0, Planet.getGuiColor(planet).getColor());
            if (planet.hasOwner() && (owner = Minecraft.func_71410_x().field_71441_e.func_152378_a(planet.getOwnerUUID())) != null) {
                String info = String.format("[%s]", owner.func_145748_c_().func_150254_d());
                width = Minecraft.func_71410_x().field_71466_p.func_78256_a(info);
                Minecraft.func_71410_x().field_71466_p.func_78276_b(TextFormatting.GOLD + info, -width / 2, -10, 0xFFFFFF);
            }
        }
    }

    private void drawPlanetOrbit(Planet planet, double radius) {
        GlStateManager.func_179090_x();
        GL11.glPolygonMode((int)1028, (int)6913);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        wr.func_181666_a(Planet.getGuiColor(planet).getFloatR() * 0.1f, Planet.getGuiColor(planet).getFloatG() * 0.1f, Planet.getGuiColor(planet).getFloatB() * 0.1f, Planet.getGuiColor(planet).getFloatA() * 0.1f);
        for (int i = 0; i < 32; ++i) {
            double angleStep = 0.19634954084936207;
            wr.func_181662_b(Math.sin(angleStep * (double)i) * radius, 0.0, Math.cos(angleStep * (double)i) * radius).func_181675_d();
            wr.func_181662_b(Math.sin(angleStep * (double)(i + 1)) * radius, 0.0, Math.cos(angleStep * (double)(i + 1)) * radius).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void bindTexture(ResourceLocation location) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
    }

    public void renderSphere(int color) {
        List quadList = star_model.func_188616_a(null, null, 0L);
        for (BakedQuad quad : quadList) {
            Tessellator.func_178181_a().func_178180_c().func_178981_a(quad.func_178209_a());
            Tessellator.func_178181_a().func_178180_c().func_178968_d(color);
        }
    }
}

