/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import matteroverdrive.tile.pipes.TileEntityPipe;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererPipe
extends TileEntitySpecialRenderer<TileEntityPipe> {
    protected static final double size = 0.3333333333333333;
    private static final Vector4d pv1 = new Vector4d(1.0, 1.0, 0.0, 1.0);
    private static final Vector4d pv2 = new Vector4d(1.0, 0.0, 0.0, 1.0);
    private static final Vector4d pv3 = new Vector4d(0.0, 0.0, 0.0, 1.0);
    private static final Vector4d pv4 = new Vector4d(0.0, 1.0, 0.0, 1.0);
    final boolean drawInside = false;
    final float texPixel = 0.0625f;
    ResourceLocation texture = new ResourceLocation("matteroverdrive:textures/blocks/pipe.png");

    public void render(TileEntityPipe pipe, double x, double y, double z, float f, int destroyStage, float a) {
        if (!pipe.shouldRender()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (this.texture != null) {
            this.func_147499_a(this.texture);
        }
        this.drawCore(pipe, x, y, z, f, this.drawSides(pipe, x, y, z, f));
        GlStateManager.func_179121_F();
    }

    protected int drawSides(TileEntityPipe pipe, double x, double y, double z, float f) {
        int connections = pipe.getConnectionsMask();
        for (int i = 0; i < 6; ++i) {
            if (!MOMathHelper.getBoolean(connections, i)) continue;
            this.drawSide(pipe, EnumFacing.field_82609_l[i]);
        }
        return connections;
    }

    protected void drawCore(TileEntityPipe tile, double x, double y, double z, float f, int sides) {
        Vector2f uv = this.getCoreUV(tile);
        AxisAngle4d rotation = new AxisAngle4d();
        if (sides == 3) {
            uv = this.getSidesUV(tile, EnumFacing.UP);
            rotation = new AxisAngle4d(0.0, 0.0, 1.0, 90.0);
        } else if (sides == 12) {
            uv = this.getSidesUV(tile, EnumFacing.NORTH);
            rotation = new AxisAngle4d(0.0, 1.0, 0.0, 90.0);
        } else if (sides == 48) {
            uv = this.getSidesUV(tile, EnumFacing.WEST);
            rotation = new AxisAngle4d(0.0, 0.0, 1.0, 180.0);
        }
        this.drawCube(uv, rotation, new Vec3d(0.0, 0.0, 0.0));
        GL11.glEnable((int)2884);
    }

    protected Vector2f getCoreUV(TileEntity entity) {
        return new Vector2f(0.0f, 0.0f);
    }

    protected Vector2f getSidesUV(TileEntity entity, EnumFacing dir) {
        return new Vector2f(1.0f, 0.0f);
    }

    protected void drawSide(TileEntityPipe tile, EnumFacing dir) {
        Vec3d offset = new Vec3d((double)dir.func_176730_m().func_177958_n() * 0.3333333333333333, (double)dir.func_176730_m().func_177956_o() * 0.3333333333333333, (double)dir.func_176730_m().func_177952_p() * 0.3333333333333333);
        Vector2f uv = this.getSidesUV(tile, dir);
        if (dir == EnumFacing.UP || dir == EnumFacing.DOWN) {
            this.drawCube(uv, new AxisAngle4d(0.0, 0.0, 1.0, 90.0), offset);
        } else if (dir == EnumFacing.WEST || dir == EnumFacing.EAST) {
            this.drawCube(uv, new AxisAngle4d(0.0, 0.0, 1.0, 180.0), offset);
        } else {
            this.drawCube(uv, new AxisAngle4d(0.0, 1.0, 0.0, 90.0), offset);
        }
        GL11.glEnable((int)2884);
    }

    void drawCube(Vector2f uv, AxisAngle4d rot, Vec3d pos) {
        this.drawPlane(new Vector3d(0.0, 0.0, 1.0), new AxisAngle4d(1.0, 0.0, 0.0, -90.0), 0.3333333333333333, uv, rot, pos);
        this.drawPlane(new Vector3d(0.0, 1.0, 0.0), new AxisAngle4d(1.0, 0.0, 0.0, 90.0), 0.3333333333333333, uv, rot, pos);
        this.drawPlane(new Vector3d(), new AxisAngle4d(0.0, 1.0, 0.0, 0.0), 0.3333333333333333, uv, rot, pos);
        this.drawPlane(new Vector3d(1.0, 0.0, 1.0), new AxisAngle4d(0.0, 1.0, 0.0, 180.0), 0.3333333333333333, uv, rot, pos);
        this.drawPlane(new Vector3d(0.0, 0.0, 1.0), new AxisAngle4d(0.0, 1.0, 0.0, 90.0), 0.3333333333333333, uv, rot, pos);
        this.drawPlane(new Vector3d(1.0, 0.0, 0.0), new AxisAngle4d(0.0, 1.0, 0.0, 270.0), 0.3333333333333333, uv, rot, pos);
    }

    void drawPlane(Vector3d pos, AxisAngle4d rot, double scale, Vector2f uv, AxisAngle4d globalRot, Vec3d globalPos) {
        GlStateManager.func_179094_E();
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181710_j);
        GlStateManager.func_179137_b((double)globalPos.field_72450_a, (double)globalPos.field_72448_b, (double)globalPos.field_72449_c);
        GlStateManager.func_179137_b((double)(0.5 - scale / 2.0), (double)(0.5 - scale / 2.0), (double)(0.5 - scale / 2.0));
        GlStateManager.func_179137_b((double)(scale / 2.0), (double)(scale / 2.0), (double)(scale / 2.0));
        GlStateManager.func_179114_b((float)((float)globalRot.angle), (float)((float)globalRot.x), (float)((float)globalRot.y), (float)((float)globalRot.z));
        GlStateManager.func_179137_b((double)(-scale / 2.0), (double)(-scale / 2.0), (double)(-scale / 2.0));
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        GlStateManager.func_179137_b((double)pos.x, (double)pos.y, (double)pos.z);
        GlStateManager.func_179114_b((float)((float)rot.angle), (float)((float)rot.x), (float)((float)rot.y), (float)((float)rot.z));
        Vector2f uv1 = new Vector2f(1.0f, 1.0f);
        uv1.add((Tuple2f)uv);
        uv1.scale(0.375f);
        Vector2f uv2 = new Vector2f(1.0f, 0.0f);
        uv2.add((Tuple2f)uv);
        uv2.scale(0.375f);
        Vector2f uv3 = new Vector2f(0.0f, 0.0f);
        uv3.add((Tuple2f)uv);
        uv3.scale(0.375f);
        Vector2f uv4 = new Vector2f(0.0f, 1.0f);
        uv4.add((Tuple2f)uv);
        uv4.scale(0.375f);
        Vector3f normal = new Vector3f(0.0f, 0.0f, -1.0f);
        this.addVertexWithUV(pv1, uv1.x, uv1.y, normal);
        this.addVertexWithUV(pv2, uv2.x, uv2.y, normal);
        this.addVertexWithUV(pv3, uv3.x, uv3.y, normal);
        this.addVertexWithUV(pv4, uv4.x, uv4.y, normal);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }

    void addVertexWithUV(Vector4d vec, float u, float v, Vector3f normal) {
        Tessellator.func_178181_a().func_178180_c().func_181662_b(vec.x, vec.y, vec.z).func_187315_a((double)u, (double)v).func_181663_c(normal.getX(), normal.getY(), normal.getZ()).func_181675_d();
    }
}

