/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.client.resources.data.PackMetadataSection;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ShaderManager {
    private static ShaderResourcePack shaderPack = new ShaderResourcePack();
    private static Field _listShaders;

    public static void initPack() {
        ((List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"field_110449_ao", "defaultResourcePacks"})).add(shaderPack);
    }

    public static void preInit() {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)shaderPack);
    }

    public static void checkList() {
        if (_listShaders == null) {
            _listShaders = ReflectionHelper.findField(ShaderGroup.class, (String[])new String[]{"field_148031_d", "listShaders"});
        }
    }

    public static void loadBlackholeAndRunRender(Runnable runnable) {
        ShaderManager.checkList();
        if (Minecraft.func_71410_x().field_71441_e != null) {
            EntityRenderer er = Minecraft.func_71410_x().field_71460_t;
            if (!er.func_147702_a()) {
                er.func_175069_a(new ResourceLocation("matteroverdrive", "shaders/blackhole.json"));
            } else {
                er.func_181022_b();
            }
        }
    }

    public static class ShaderResourcePack
    implements IResourcePack,
    IResourceManagerReloadListener {
        private final Map<ResourceLocation, String> loadedData = new HashMap<ResourceLocation, String>();

        protected boolean validPath(ResourceLocation location) {
            return location.func_110624_b().equals("matteroverdrive") && location.func_110623_a().startsWith("shaders/");
        }

        public void func_110549_a(IResourceManager resourceManager) {
            this.loadedData.clear();
        }

        public InputStream func_110590_a(ResourceLocation location) throws IOException {
            if (this.validPath(location)) {
                String s = this.loadedData.computeIfAbsent(location, loc -> {
                    InputStream in = ShaderManager.class.getResourceAsStream("/" + location.func_110623_a());
                    StringBuilder data = new StringBuilder();
                    try (Scanner scan = new Scanner(in);){
                        while (scan.hasNextLine()) {
                            data.append(scan.nextLine()).append('\n');
                        }
                    }
                    return data.toString();
                });
                return new ByteArrayInputStream(s.getBytes());
            }
            throw new FileNotFoundException(location.toString());
        }

        public boolean func_110589_b(ResourceLocation location) {
            return this.validPath(location) && ShaderManager.class.getResource("/" + location.func_110623_a()) != null;
        }

        public Set<String> func_110587_b() {
            return ImmutableSet.of((Object)"matteroverdrive");
        }

        @Nullable
        public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
            if ("pack".equals(metadataSectionName)) {
                return (T)new PackMetadataSection((ITextComponent)new TextComponentString("MatterOverdrive shaders"), 3);
            }
            return null;
        }

        public BufferedImage func_110586_a() throws IOException {
            throw new FileNotFoundException("pack.png");
        }

        public String func_130077_b() {
            return "MatterOverdrive Shaders Pack";
        }
    }
}

