/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import java.util.Random;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.IWorldLastRenderer;
import matteroverdrive.util.MOPhysicsHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class RenderBeam<T extends EntityLivingBase>
implements IWorldLastRenderer {
    protected final Random random = new Random();

    protected abstract boolean shouldRenderBeam(T var1);

    protected abstract void onBeamRaycastHit(RayTraceResult var1, T var2);

    protected abstract void onBeamRender(T var1);

    protected abstract Color getBeamColor(T var1);

    protected abstract ResourceLocation getBeamTexture(T var1);

    protected abstract float getBeamMaxDistance(T var1);

    protected abstract float getBeamThickness(T var1);

    protected boolean renderRaycastedBeam(Vec3d direction, Vec3d offset, T caster) {
        return this.renderRaycastedBeam(caster.func_174824_e(1.0f), direction, offset, caster);
    }

    protected boolean renderRaycastedBeam(Vec3d position, Vec3d direction, Vec3d offset, T caster) {
        double maxDistance = this.getBeamMaxDistance(caster);
        RayTraceResult hit = MOPhysicsHelper.rayTrace(position, ((EntityLivingBase)caster).field_70170_p, maxDistance, 0.0f, new Vec3d(0.0, 0.0, 0.0), false, true, direction, caster);
        if (hit != null && hit.field_72313_a != RayTraceResult.Type.MISS) {
            this.renderBeam(position.func_178787_e(direction.func_186678_a(0.2)), hit.field_72307_f, offset, this.getBeamColor(caster), this.getBeamTexture(caster), this.getBeamThickness(caster), caster);
            this.onBeamRender(caster);
            this.onBeamRaycastHit(hit, caster);
            return true;
        }
        this.renderBeam(position.func_178787_e(direction.func_186678_a(0.2)), position.func_72441_c(direction.field_72450_a * maxDistance, direction.field_72448_b * maxDistance, direction.field_72449_c * maxDistance), offset, this.getBeamColor(caster), this.getBeamTexture(caster), this.getBeamThickness(caster), caster);
        this.onBeamRender(caster);
        return false;
    }

    protected void renderBeam(Vec3d from, Vec3d to, Vec3d offest, Color color, ResourceLocation texture, float tickness, T viewer) {
        if (texture != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        }
        RenderUtils.applyColor(color);
        double distance = from.func_178788_d(to).func_72433_c();
        double v = (double)(-((EntityLivingBase)viewer).field_70170_p.func_72820_D()) * 0.2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)from.field_72450_a, (double)from.field_72448_b, (double)from.field_72449_c);
        GlStateManager.func_179114_b((float)(-viewer.func_70079_am()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((EntityLivingBase)viewer).field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)offest.field_72450_a, (double)offest.field_72448_b, (double)offest.field_72449_c);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)tickness, 0.0, 0.0).func_187315_a(0.0, v).func_181675_d();
        wr.func_181662_b((double)tickness, 0.0, distance).func_187315_a(0.0, v + distance * 1.5).func_181675_d();
        wr.func_181662_b((double)(-tickness), 0.0, distance).func_187315_a(1.0, v + distance * 1.5).func_181675_d();
        wr.func_181662_b((double)(-tickness), 0.0, 0.0).func_187315_a(1.0, v).func_181675_d();
        wr.func_181662_b(0.0, (double)tickness, 0.0).func_187315_a(0.0, v).func_181675_d();
        wr.func_181662_b(0.0, (double)tickness, distance).func_187315_a(0.0, v + distance * 1.5).func_181675_d();
        wr.func_181662_b(0.0, (double)(-tickness), distance).func_187315_a(1.0, v + distance * 1.5).func_181675_d();
        wr.func_181662_b(0.0, (double)(-tickness), 0.0).func_187315_a(1.0, v).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }
}

