/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.inventory.IBlockScanner;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.render.IWorldLastRenderer;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class DimensionalRiftsRender
implements IWorldLastRenderer {
    Random random = new Random();
    double lastY;
    float[][] points = new float[128][128];

    @Override
    public void onRenderWorldLast(RenderHandler handler, RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean holdingPad = false;
        ItemStack heldItem = ItemStack.field_190927_a;
        if (!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem.func_77973_b() instanceof IBlockScanner && ((IBlockScanner)heldItem.func_77973_b()).showsGravitationalWaves(heldItem)) {
                holdingPad = true;
            } else {
                heldItem = ItemStack.field_190927_a;
            }
        } else if (!player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
            heldItem = player.func_184586_b(EnumHand.OFF_HAND);
            if (heldItem.func_77973_b() instanceof IBlockScanner && ((IBlockScanner)heldItem.func_77973_b()).showsGravitationalWaves(heldItem)) {
                holdingPad = true;
            } else {
                heldItem = ItemStack.field_190927_a;
            }
        }
        if (holdingPad && !heldItem.func_190926_b()) {
            float b;
            float g;
            float r;
            double zPos;
            int x;
            int z;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179132_a((boolean)true);
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glPointSize((float)6.0f);
            GL11.glLineWidth((float)1.0f);
            Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
            Vec3d viewEntityPos = renderViewEntity.func_174824_e(event.getPartialTicks()).func_178786_a(0.0, (double)renderViewEntity.func_70047_e(), 0.0);
            if (this.lastY == 0.0) {
                this.lastY = 64.0;
            }
            if (renderViewEntity.field_70122_E) {
                this.lastY = MOMathHelper.Lerp(this.lastY, viewEntityPos.field_72448_b, 0.05);
            }
            Vec3d viewEntityPosRound = new Vec3d(Math.floor(viewEntityPos.field_72450_a), this.lastY, Math.floor(viewEntityPos.field_72449_c));
            GlStateManager.func_179137_b((double)(-viewEntityPos.field_72450_a), (double)(-viewEntityPos.field_72448_b), (double)(-viewEntityPos.field_72449_c));
            BufferBuilder worldRenderer = Tessellator.func_178181_a().func_178180_c();
            int vewDistance = 128;
            double height = 5.0;
            this.random.setSeed(Minecraft.func_71410_x().field_71441_e.func_72905_C());
            for (int x2 = 0; x2 < vewDistance; ++x2) {
                for (int z2 = 0; z2 < vewDistance; ++z2) {
                    float yPos = MatterOverdrive.MO_WORLD.getDimensionalRifts().getValueAt(new Vec3d(viewEntityPosRound.field_72450_a + (double)x2 - (double)(vewDistance / 2), 0.0, viewEntityPosRound.field_72449_c + (double)z2 - (double)(vewDistance / 2)));
                    this.points[x2][z2] = yPos = (float)((double)yPos * (Math.sin((double)x2 / (double)vewDistance * Math.PI) * Math.sin((double)z2 / (double)vewDistance * Math.PI)));
                }
            }
            GlStateManager.func_179137_b((double)0.0, (double)viewEntityPosRound.field_72448_b, (double)0.0);
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (z = 0; z < vewDistance; ++z) {
                for (x = 0; x < vewDistance; ++x) {
                    if (!((double)this.points[x][z] > 0.01)) continue;
                    double xPos = viewEntityPosRound.field_72450_a + (double)x - (double)((float)vewDistance / 2.0f);
                    zPos = viewEntityPosRound.field_72449_c + (double)z - (double)((float)vewDistance / 2.0f);
                    r = Reference.COLOR_HOLO.getFloatR() * this.points[x][z];
                    g = Reference.COLOR_HOLO.getFloatG() * this.points[x][z];
                    b = Reference.COLOR_HOLO.getFloatB() * this.points[x][z];
                    worldRenderer.func_181662_b(xPos, this.getPointSafe(x, z) * height, zPos).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    worldRenderer.func_181662_b(xPos, this.getPointSafe(x, z + 1) * height, zPos + 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    worldRenderer.func_181662_b(xPos + 1.0, this.getPointSafe(x + 1, z + 1) * height, zPos + 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    worldRenderer.func_181662_b(xPos + 1.0, this.getPointSafe(x + 1, z) * height, zPos).func_181666_a(r, g, b, 1.0f).func_181675_d();
                }
            }
            Tessellator.func_178181_a().func_78381_a();
            worldRenderer.func_181668_a(0, DefaultVertexFormats.field_181706_f);
            for (z = 0; z < vewDistance; ++z) {
                for (x = 0; x < vewDistance; ++x) {
                    if (!((double)this.points[x][z] > 0.01)) continue;
                    double xPos = viewEntityPosRound.field_72450_a + (double)x - (double)(vewDistance / 2);
                    zPos = viewEntityPosRound.field_72449_c + (double)z - (double)(vewDistance / 2);
                    r = Reference.COLOR_HOLO.getFloatR() * this.points[x][z];
                    g = Reference.COLOR_HOLO.getFloatG() * this.points[x][z];
                    b = Reference.COLOR_HOLO.getFloatB() * this.points[x][z];
                    worldRenderer.func_181662_b(xPos, this.getPointSafe(x, z) * height, zPos).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    worldRenderer.func_181662_b(xPos, this.getPointSafe(x, z + 1) * height, zPos + 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    worldRenderer.func_181662_b(xPos + 1.0, this.getPointSafe(x + 1, z + 1) * height, zPos + 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    worldRenderer.func_181662_b(xPos + 1.0, this.getPointSafe(x + 1, z) * height, zPos).func_181666_a(r, g, b, 1.0f).func_181675_d();
                }
            }
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPolygonMode((int)1032, (int)6914);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    public double getPointSafe(int x, int y) {
        return this.points[MathHelper.func_76125_a((int)x, (int)0, (int)127)][MathHelper.func_76125_a((int)y, (int)0, (int)127)];
    }
}

