/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import matteroverdrive.api.wrench.IDismantleable;
import matteroverdrive.blocks.BlockMonitor;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.tile.TileEntityHoloSign;
import matteroverdrive.util.MOInventoryHelper;
import matteroverdrive.util.MachineHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHoloSign
extends BlockMonitor<TileEntityHoloSign>
implements IDismantleable {
    public BlockHoloSign(Material material, String name) {
        super(material, name);
        this.setBoundingBox(new AxisAlignedBB(0.0, 1.0, 0.0, 1.0, 0.875, 1.0));
        this.func_149711_c(20.0f);
        this.setHasRotation();
    }

    @Override
    public Class<TileEntityHoloSign> getTileEntityClass() {
        return TileEntityHoloSign.class;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityHoloSign();
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos neighbor) {
        EnumFacing l = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION);
        boolean flag = false;
        IBlockState nState = world.func_180495_p(pos.func_177972_a(l));
        if (nState.func_193401_d((IBlockAccess)world, pos.func_177972_a(l), l.func_176734_d()) == BlockFaceShape.SOLID) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, blockIn, neighbor);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return MachineHelper.canOpenMachine(worldIn, pos, playerIn, true, "alert.no_rights");
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return MachineHelper.canRemoveMachine(world, player, pos, willHarvest) && world.func_175698_g(pos);
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, BlockPos pos, boolean returnDrops) {
        IBlockState blockState = world.func_180495_p(pos);
        ItemStack blockItem = new ItemStack(this.func_180660_a(blockState, world.field_73012_v, 1));
        boolean flag = blockState.func_177230_c().removedByPlayer(blockState, world, pos, player, true);
        super.func_180663_b(world, pos, blockState);
        if (flag) {
            blockState.func_177230_c().func_176206_d(world, pos, blockState);
        }
        if (!returnDrops) {
            this.func_176226_b(world, pos, blockState, 0);
        } else {
            MOInventoryHelper.insertItemStackIntoInventory((IInventory)player.field_71071_by, blockItem, EnumFacing.DOWN);
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(blockItem);
        return list;
    }

    @Override
    public boolean canDismantle(EntityPlayer entityPlayer, World world, BlockPos pos) {
        return true;
    }
}

