/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import javax.annotation.Nonnull;
import matteroverdrive.blocks.includes.MOBlockMachine;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.machines.fusionReactorController.TileEntityMachineFusionReactorController;
import matteroverdrive.util.MOBlockHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockFusionReactorController
extends MOBlockMachine<TileEntityMachineFusionReactorController> {
    public BlockFusionReactorController(Material material, String name) {
        super(material, name);
        this.func_149711_c(30.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.setHasGui(true);
        this.field_149784_t = 10;
        this.setRotationType(MOBlockHelper.RotationType.SIX_WAY);
        this.setHasRotation();
    }

    @Override
    public Class<TileEntityMachineFusionReactorController> getTileEntityClass() {
        return TileEntityMachineFusionReactorController.class;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityMachineFusionReactorController();
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMachineFusionReactorController && ((TileEntityMachineFusionReactorController)tileEntity).isValidStructure()) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        super.onConfigChanged(config);
        TileEntityMachineFusionReactorController.ENERGY_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.energy", 100000000, String.format("How much energy can the %s hold", this.func_149732_F()));
        TileEntityMachineFusionReactorController.MATTER_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.matter", 2048, String.format("How much matter can the %s hold", this.func_149732_F()));
        TileEntityMachineFusionReactorController.ENERGY_PER_TICK = config.getMachineInt(this.func_149739_a(), "output.energy", 2048, "The Energy Output per tick. Dependant on the size of the anomaly as well");
        TileEntityMachineFusionReactorController.MATTER_DRAIN_PER_TICK = (float)config.getMachineDouble(this.func_149739_a(), "drain.matter", 0.0125, "How much matter is drained per tick. Dependant on the size of the anomaly as well");
        TileEntityMachineFusionReactorController.MAX_GRAVITATIONAL_ANOMALY_DISTANCE = config.getMachineInt(this.func_149739_a(), "distance.anomaly", 3, "The maximum distance of the anomaly");
        TileEntityMachineFusionReactorController.STRUCTURE_CHECK_DELAY = config.getMachineInt(this.func_149739_a(), "check.delay", 40, "The time delay between each structure check");
    }
}

