/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.wrench.IDismantleable;
import matteroverdrive.blocks.includes.MOBlockContainer;
import matteroverdrive.tile.IMultiBlockTileEntity;
import matteroverdrive.tile.TileEntityBoundingBox;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBoundingBox
extends MOBlockContainer<TileEntityBoundingBox>
implements IDismantleable {
    public BlockBoundingBox(String name) {
        super(Material.field_151576_e, name);
        this.func_149647_a(null);
    }

    public static void createBoundingBox(World world, BlockPos pos, BlockPos ownerPos, Block ownerBlock) {
        world.func_175656_a(pos, MatterOverdrive.BLOCKS.boundingBox.func_176223_P());
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityBoundingBox) {
            TileEntityBoundingBox boundingBox = (TileEntityBoundingBox)te;
            boundingBox.setOwnerPos(ownerPos);
            boundingBox.setOwnerBlock(ownerBlock);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityBoundingBox te = (TileEntityBoundingBox)this.getTileEntity((IBlockAccess)world, pos);
        IBlockState ownerState = world.func_180495_p(te.getOwnerPos());
        if (ownerState.func_177230_c() == te.getOwnerBlock()) {
            return te.getOwnerBlock().func_180639_a(world, te.getOwnerPos(), ownerState, player, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityBoundingBox te = (TileEntityBoundingBox)this.getTileEntity((IBlockAccess)world, pos);
        return te.getOwnerBlock().getPickBlock(world.func_180495_p(te.getOwnerPos()), target, world, te.getOwnerPos(), player);
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Deprecated
    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        TileEntityBoundingBox te = (TileEntityBoundingBox)this.getTileEntity((IBlockAccess)world, pos);
        return te.getOwnerBlock().func_176195_g(world.func_180495_p(te.getOwnerPos()), world, te.getOwnerPos());
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityBoundingBox te = (TileEntityBoundingBox)this.getTileEntity((IBlockAccess)world, pos);
        TileEntity ownerTe = world.func_175625_s(te.getOwnerPos());
        if (ownerTe instanceof IMultiBlockTileEntity) {
            ((IMultiBlockTileEntity)ownerTe).getBoundingBlocks().forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
        }
        world.func_175655_b(te.getOwnerPos(), true);
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, BlockPos pos, boolean returnDrops) {
        TileEntityBoundingBox te = (TileEntityBoundingBox)this.getTileEntity((IBlockAccess)world, pos);
        if (te.getOwnerBlock() instanceof IDismantleable) {
            return ((IDismantleable)te.getOwnerBlock()).dismantleBlock(player, world, te.getOwnerPos(), returnDrops);
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, BlockPos pos) {
        TileEntityBoundingBox te = (TileEntityBoundingBox)this.getTileEntity((IBlockAccess)world, pos);
        return te.getOwnerBlock() instanceof IDismantleable && ((IDismantleable)te.getOwnerBlock()).canDismantle(player, world, te.getOwnerPos());
    }

    @Override
    public Class<TileEntityBoundingBox> getTileEntityClass() {
        return TileEntityBoundingBox.class;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityBoundingBox();
    }
}

