/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import matteroverdrive.OverdriveTab;
import matteroverdrive.commands.AndoidCommands;
import matteroverdrive.commands.CommandMatterRegistry;
import matteroverdrive.commands.QuestCommands;
import matteroverdrive.commands.WorldGenCommands;
import matteroverdrive.compat.MatterOverdriveCompat;
import matteroverdrive.entity.EntityVillagerMadScientist;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.handler.AndroidStatRegistry;
import matteroverdrive.handler.BlockHandler;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.EntityHandler;
import matteroverdrive.handler.GuiHandler;
import matteroverdrive.handler.MatterRegistrationHandler;
import matteroverdrive.handler.MatterRegistry;
import matteroverdrive.handler.PlayerEventHandler;
import matteroverdrive.handler.TickHandler;
import matteroverdrive.handler.dialog.DialogAssembler;
import matteroverdrive.handler.dialog.DialogRegistry;
import matteroverdrive.handler.matter_network.FluidNetworkHandler;
import matteroverdrive.handler.matter_network.MatterNetworkHandler;
import matteroverdrive.handler.quest.QuestAssembler;
import matteroverdrive.handler.quest.Quests;
import matteroverdrive.imc.MOIMCHandler;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.init.MatterOverdriveDialogs;
import matteroverdrive.init.MatterOverdriveEnchantments;
import matteroverdrive.init.MatterOverdriveEntities;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.init.MatterOverdriveMatter;
import matteroverdrive.init.MatterOverdriveQuests;
import matteroverdrive.init.MatterOverdriveRecipes;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.init.MatterOverdriveWorld;
import matteroverdrive.init.OverdriveBioticStats;
import matteroverdrive.init.OverdriveFluids;
import matteroverdrive.matter_network.MatterNetworkRegistry;
import matteroverdrive.network.PacketPipeline;
import matteroverdrive.proxy.CommonProxy;
import matteroverdrive.util.AndroidPartsFactory;
import matteroverdrive.util.DialogFactory;
import matteroverdrive.util.QuestFactory;
import matteroverdrive.util.WeaponFactory;
import matteroverdrive.world.MOLootTableManager;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="matteroverdrive", name="MatterOverdrive: Legacy Edition", version="0.7.0.0", guiFactory="matteroverdrive.gui.GuiConfigFactory", dependencies="", acceptedMinecraftVersions="[1.12.2]")
public class MatterOverdrive {
    public static final ExecutorService THREAD_POOL = Executors.newFixedThreadPool(2);
    public static final MatterOverdriveItems ITEMS = new MatterOverdriveItems();
    public static final MatterOverdriveBlocks BLOCKS = new MatterOverdriveBlocks();
    public static final OverdriveTab TAB_OVERDRIVE = new OverdriveTab("tabMO", () -> new ItemStack((Item)MatterOverdrive.ITEMS.matter_scanner));
    public static final OverdriveTab TAB_OVERDRIVE_MODULES = new OverdriveTab("tabMO_modules", () -> new ItemStack((Item)MatterOverdrive.ITEMS.weapon_module_color));
    public static final OverdriveTab TAB_OVERDRIVE_CONTRACTS = new OverdriveTab("tabMO_contracts", () -> new ItemStack((Item)MatterOverdrive.ITEMS.contract));
    public static final OverdriveTab TAB_OVERDRIVE_ANDROID_PARTS = new OverdriveTab("tabMO_androidParts", () -> new ItemStack((Item)MatterOverdrive.ITEMS.androidParts));
    public static final TickHandler TICK_HANDLER;
    public static final PlayerEventHandler PLAYER_EVENT_HANDLER;
    public static final ConfigurationHandler CONFIG_HANDLER;
    public static final GuiHandler GUI_HANDLER;
    public static final PacketPipeline NETWORK;
    public static final MatterOverdriveWorld MO_WORLD;
    public static final EntityHandler ENTITY_HANDLER;
    public static final MatterRegistry MATTER_REGISTRY;
    public static final AndroidStatRegistry STAT_REGISTRY;
    public static final DialogRegistry DIALOG_REGISTRY;
    public static final MatterRegistrationHandler MATTER_REGISTRATION_HANDLER;
    public static final WeaponFactory WEAPON_FACTORY;
    public static final AndroidPartsFactory ANDROID_PARTS_FACTORY;
    public static final Quests QUESTS;
    public static final QuestFactory QUEST_FACTORY;
    public static final DialogFactory DIALOG_FACTORY;
    public static final BlockHandler BLOCK_HANDLER;
    public static final QuestAssembler QUEST_ASSEMBLER;
    public static final DialogAssembler DIALOG_ASSEMBLER;
    public static final MatterNetworkHandler MATTER_NETWORK_HANDLER;
    public static final FluidNetworkHandler FLUID_NETWORK_HANDLER;
    public static final MOLootTableManager LOOT_TABLE_MANAGER;
    @Mod.Instance(value="matteroverdrive")
    public static MatterOverdrive INSTANCE;
    @SidedProxy(clientSide="matteroverdrive.proxy.ClientProxy", serverSide="matteroverdrive.proxy.CommonProxy")
    public static CommonProxy PROXY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        AndroidPlayer.register();
        OverdriveExtendedProperties.register();
        ITEMS.init();
        OverdriveFluids.init(event);
        BLOCKS.init();
        OverdriveBioticStats.init();
        MatterOverdriveDialogs.init(CONFIG_HANDLER, DIALOG_REGISTRY);
        MatterOverdriveQuests.init();
        MatterOverdriveQuests.register(QUESTS);
        MatterOverdriveSounds.register();
        EntityVillagerMadScientist.registerDialogMessages(DIALOG_REGISTRY, event.getSide());
        MatterOverdriveCapabilities.init();
        MinecraftForge.EVENT_BUS.register((Object)MATTER_REGISTRATION_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)CONFIG_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)TICK_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)PLAYER_EVENT_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)BLOCK_HANDLER);
        MatterOverdriveEntities.init(event, CONFIG_HANDLER);
        MatterOverdriveEnchantments.init(event, CONFIG_HANDLER);
        MO_WORLD.init(CONFIG_HANDLER);
        MatterNetworkRegistry.register();
        NETWORK.registerPackets();
        OverdriveBioticStats.registerAll(CONFIG_HANDLER, STAT_REGISTRY);
        MATTER_REGISTRY.preInit(event, CONFIG_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)MATTER_NETWORK_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)FLUID_NETWORK_HANDLER);
        MatterOverdriveEntities.register(event);
        PROXY.preInit(event);
        MatterOverdriveCompat.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GUI_HANDLER.register(event.getSide());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)GUI_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)ENTITY_HANDLER);
        CONFIG_HANDLER.init();
        MatterOverdriveCompat.init(event);
        PROXY.init(event);
        MatterOverdriveRecipes.registerMachineRecipes(event);
        WEAPON_FACTORY.initModules();
        WEAPON_FACTORY.initWeapons();
        ANDROID_PARTS_FACTORY.initParts();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
        MatterOverdriveCompat.postInit(event);
        ITEMS.addToDungons();
        QUEST_ASSEMBLER.loadQuests(QUESTS);
        QUEST_ASSEMBLER.loadCustomQuests(QUESTS);
        DIALOG_ASSEMBLER.loadDialogs(DIALOG_REGISTRY);
        DIALOG_ASSEMBLER.loadCustomDialogs(DIALOG_REGISTRY);
        MatterOverdriveMatter.registerBlacklistFromConfig(CONFIG_HANDLER);
        MatterOverdriveMatter.registerBasic(CONFIG_HANDLER);
        CONFIG_HANDLER.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new AndoidCommands());
        event.registerServerCommand((ICommand)new CommandMatterRegistry());
        event.registerServerCommand((ICommand)new QuestCommands());
        event.registerServerCommand((ICommand)new WorldGenCommands());
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        TICK_HANDLER.onServerStart(event);
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        MOIMCHandler.imcCallback(event);
    }

    static {
        FluidRegistry.enableUniversalBucket();
        CONFIG_HANDLER = new ConfigurationHandler(new File("config"));
        MATTER_REGISTRY = new MatterRegistry();
        STAT_REGISTRY = new AndroidStatRegistry();
        DIALOG_REGISTRY = new DialogRegistry();
        GUI_HANDLER = new GuiHandler();
        NETWORK = new PacketPipeline();
        ENTITY_HANDLER = new EntityHandler();
        PLAYER_EVENT_HANDLER = new PlayerEventHandler(CONFIG_HANDLER);
        MATTER_REGISTRATION_HANDLER = new MatterRegistrationHandler();
        WEAPON_FACTORY = new WeaponFactory();
        ANDROID_PARTS_FACTORY = new AndroidPartsFactory();
        QUESTS = new Quests();
        QUEST_FACTORY = new QuestFactory();
        DIALOG_FACTORY = new DialogFactory(DIALOG_REGISTRY);
        BLOCK_HANDLER = new BlockHandler();
        QUEST_ASSEMBLER = new QuestAssembler();
        DIALOG_ASSEMBLER = new DialogAssembler();
        MATTER_NETWORK_HANDLER = new MatterNetworkHandler();
        FLUID_NETWORK_HANDLER = new FluidNetworkHandler();
        LOOT_TABLE_MANAGER = new MOLootTableManager();
        TICK_HANDLER = new TickHandler(CONFIG_HANDLER, PLAYER_EVENT_HANDLER);
        MO_WORLD = new MatterOverdriveWorld(CONFIG_HANDLER);
    }
}

