/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.endergy.capacitor;

import com.enderio.core.common.CompoundCapabilityProvider;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.CapabilityCapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.endergy.capacitor.EndergyCapacitorData;
import crazypants.enderio.endergy.capacitor.ItemEndergyCapacitor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemTotemicCapacitor
extends ItemEndergyCapacitor {
    public static ItemTotemicCapacitor create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemTotemicCapacitor(modObject, EndergyCapacitorData.TOTEMIC_CAPACITOR, 512);
    }

    public ItemTotemicCapacitor(@Nonnull IModObject modObject, @Nonnull ICapacitorData data, int damage) {
        super(modObject, data, damage);
    }

    @Override
    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        if (enchantment == Enchantments.field_185305_q) {
            return true;
        }
        EnumEnchantmentType type = enchantment.field_77351_y;
        return type != null && type.func_77557_a(stack.func_77973_b());
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(final @Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        ICapabilityProvider capProvider = new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == CapabilityCapacitorData.getCapNN();
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == CapabilityCapacitorData.getCapNN()) {
                    return (T)CapabilityCapacitorData.getCapNN().cast((Object)ItemTotemicCapacitor.this.getDataFromStack(stack));
                }
                return null;
            }
        };
        return new CompoundCapabilityProvider(new ICapabilityProvider[]{super.initCapabilities(stack, nbt), capProvider});
    }

    @Override
    @Nonnull
    protected ICapacitorData getDataFromStack(@Nonnull ItemStack stack) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        if (level > 0) {
            return CapacitorHelper.increaseCapacitorLevel((ICapacitorData)this.getData(), (float)((float)level / 2.0f));
        }
        return this.getData();
    }
}

