/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioBlock;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityClipboard;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class BlockClipboard
extends BiblioBlock {
    public static final String name = "Clipboard";
    public static final BlockClipboard instance = new BlockClipboard();

    public BlockClipboard() {
        super(Material.field_151575_d, SoundType.field_185848_a, null, name);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing face, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (player.func_70093_af() && !world.field_72995_K) {
            this.dropStackInSlot(world, pos, 0, pos);
            world.func_175698_g(pos);
            return true;
        }
        if (!player.func_70093_af() && world.field_72995_K && (tile = world.func_175625_s(pos)) != null && tile instanceof TileEntityClipboard) {
            TileEntityClipboard clipboard = (TileEntityClipboard)tile;
            int updatePos = this.getSelectionPointFromFace(face, hitX, hitY, hitZ);
            ByteBuf buffer = Unpooled.buffer();
            buffer.writeInt(pos.func_177958_n());
            buffer.writeInt(pos.func_177956_o());
            buffer.writeInt(pos.func_177952_p());
            buffer.writeInt(updatePos);
            BiblioCraft.ch_BiblioClipboard.sendToServer(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioClipboard"));
            return true;
        }
        return false;
    }

    private int getSelectionPointFromFace(EnumFacing face, float hitx, float hity, float hitz) {
        switch (face) {
            case NORTH: {
                return this.getSelectionPoint(1.0f - hitx, 1.0f - hity);
            }
            case SOUTH: {
                return this.getSelectionPoint(hitx, 1.0f - hity);
            }
            case WEST: {
                return this.getSelectionPoint(hitz, 1.0f - hity);
            }
            case EAST: {
                return this.getSelectionPoint(1.0f - hitz, 1.0f - hity);
            }
        }
        return -1;
    }

    private int getSelectionPoint(float x, float y) {
        if (x > 0.21f && x < 0.272f) {
            float spacing = 0.0655f;
            for (int i = 0; i < 9; ++i) {
                if (!((double)y > 0.23 + (double)((float)i * spacing)) || !(y < 0.285f + (float)i * spacing)) continue;
                return i;
            }
        }
        if ((double)y > 0.83 && y < 0.868f) {
            if (x > 0.296f && x < 0.387f) {
                return 10;
            }
            if (x > 0.599f && x < 0.843f) {
                return 11;
            }
        }
        return -1;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityClipboard();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add(name);
        if (tile instanceof TileEntityClipboard) {
            TileEntityClipboard clipboard = (TileEntityClipboard)tile;
            clipboard.getNBTData();
            switch (clipboard.button0state) {
                case 1: {
                    modelParts.add("box1c");
                    break;
                }
                case 2: {
                    modelParts.add("box1x");
                }
            }
            switch (clipboard.button1state) {
                case 1: {
                    modelParts.add("box2c");
                    break;
                }
                case 2: {
                    modelParts.add("box2x");
                }
            }
            switch (clipboard.button2state) {
                case 1: {
                    modelParts.add("box3c");
                    break;
                }
                case 2: {
                    modelParts.add("box3x");
                }
            }
            switch (clipboard.button3state) {
                case 1: {
                    modelParts.add("box4c");
                    break;
                }
                case 2: {
                    modelParts.add("box4x");
                }
            }
            switch (clipboard.button4state) {
                case 1: {
                    modelParts.add("box5c");
                    break;
                }
                case 2: {
                    modelParts.add("box5x");
                }
            }
            switch (clipboard.button5state) {
                case 1: {
                    modelParts.add("box6c");
                    break;
                }
                case 2: {
                    modelParts.add("box6x");
                }
            }
            switch (clipboard.button6state) {
                case 1: {
                    modelParts.add("box7c");
                    break;
                }
                case 2: {
                    modelParts.add("box7x");
                }
            }
            switch (clipboard.button7state) {
                case 1: {
                    modelParts.add("box8c");
                    break;
                }
                case 2: {
                    modelParts.add("box8x");
                }
            }
            switch (clipboard.button8state) {
                case 1: {
                    modelParts.add("box9c");
                    break;
                }
                case 2: {
                    modelParts.add("box9x");
                }
            }
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public ItemStack getPickBlockExtras(ItemStack stack, World world, BlockPos pos) {
        return stack;
    }

    @Override
    public ExtendedBlockState getExtendedBlockStateAlternate(ExtendedBlockState state) {
        return state;
    }

    @Override
    public IExtendedBlockState getIExtendedBlockStateAlternate(BiblioTileEntity biblioTile, IExtendedBlockState state) {
        return state;
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        return transform;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        AxisAlignedBB output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityClipboard) {
            TileEntityClipboard clipboard = (TileEntityClipboard)tile;
            switch (clipboard.getAngle()) {
                case SOUTH: {
                    output = this.getBlockBounds(0.97f, 0.08f, 0.15f, 1.0f, 0.92f, 0.85f);
                    break;
                }
                case WEST: {
                    output = this.getBlockBounds(0.15f, 0.08f, 0.97f, 0.85f, 0.92f, 1.0f);
                    break;
                }
                case NORTH: {
                    output = this.getBlockBounds(0.0f, 0.08f, 0.15f, 0.03f, 0.92f, 0.85f);
                    break;
                }
                case EAST: {
                    output = this.getBlockBounds(0.15f, 0.08f, 0.0f, 0.85f, 0.92f, 0.03f);
                    break;
                }
            }
        }
        return output;
    }

    @Override
    public IBlockState getFinalBlockstate(IBlockState state, IBlockState newState) {
        return newState;
    }
}

