/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import its_meow.betteranimalsplus.common.entity.IVariantTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityJellyfish
extends EntitySquid
implements IVariantTypes {
    protected static final DataParameter<Integer> TYPE_NUMBER = EntityDataManager.func_187226_a(EntityJellyfish.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityJellyfish.class, (DataSerializer)DataSerializers.field_187193_c);
    protected int attackCooldown = 0;

    public EntityJellyfish(World worldIn) {
        super(worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIMoveRandom(this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public void func_70100_b_(EntityPlayer entity) {
        super.func_70100_b_(entity);
        if (!entity.field_71075_bZ.field_75098_d && this.attackCooldown == 0) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
            entity.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"poison"), 200, 0, false, false));
            entity.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"blindness"), 90, 2, false, false));
            this.attackCooldown = 80;
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187886_fs;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.registerTypeKey();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void func_70105_a(float width, float height) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(width));
        super.func_70105_a(width, height);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.writeType(compound);
        compound.func_74776_a("Size", this.getSize());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.readType(compound);
        float size = compound.func_74760_g("Size");
        this.func_70105_a(size, size);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (!this.func_70631_g_()) {
            int i = this.field_70146_Z.nextInt(6) + 1;
            float rand = ((float)this.field_70146_Z.nextInt(30) + 1.0f) / 50.0f + 0.05f;
            if (livingdata instanceof JellyfishData) {
                i = ((JellyfishData)livingdata).typeData;
                rand = ((JellyfishData)livingdata).size;
            } else {
                livingdata = new JellyfishData(i, rand);
            }
            this.setType(i);
            this.func_70105_a(rand, rand);
        }
        return livingdata;
    }

    @Override
    public DataParameter<Integer> getDataKey() {
        return TYPE_NUMBER;
    }

    @Override
    public int getVariantMax() {
        return 6;
    }

    @Override
    public boolean isChildI() {
        return this.func_70631_g_();
    }

    @Override
    public Random getRNGI() {
        return this.func_70681_au();
    }

    @Override
    public EntityDataManager getDataManagerI() {
        return this.func_184212_Q();
    }

    protected boolean func_70692_ba() {
        return ModEntities.entityMap.containsKey("jellyfish") ? ModEntities.entityMap.get((Object)"jellyfish").despawn && !this.func_145818_k_() : false;
    }

    static class AIMoveRandom
    extends EntityAIBase {
        private final EntityJellyfish entity;

        public AIMoveRandom(EntityJellyfish entityIn) {
            this.entity = entityIn;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.entity.func_70654_ax();
            if (i > 100) {
                this.entity.func_175568_b(0.0f, 0.0f, 0.0f);
            } else if (this.entity.func_70681_au().nextInt(50) == 0 || !this.entity.field_70171_ac || !this.entity.func_175567_n()) {
                float f = this.entity.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.entity.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.entity.func_175568_b(f1 / 3.0f, f2 / 3.0f, f3 / 3.0f);
            }
        }
    }

    public static class JellyfishData
    implements IEntityLivingData {
        public int typeData;
        public float size;

        public JellyfishData(int type, float size) {
            this.typeData = type;
            this.size = size;
        }
    }
}

