/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.loader.blockstate;

import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.forgemodel.CCMultiModel;
import codechicken.lib.model.forgemodel.StateOverrideIModel;
import codechicken.lib.model.loader.blockstate.CCFinalVariant;
import codechicken.lib.model.loader.blockstate.CCVariant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class CCFinalMultiVariant
extends Variant {
    private Variant baseVariant;
    private ModelProperties baseProperties;
    private List<Variant> finalVariants = new LinkedList<Variant>();
    private IModelState state;

    public CCFinalMultiVariant(CCVariant baseVariant, String textureDomain, Map<String, CCVariant> subModels) {
        super(baseVariant.model == null ? new ResourceLocation("builtin/missing") : baseVariant.model, baseVariant.state.get() instanceof ModelRotation ? (ModelRotation)baseVariant.state.get() : ModelRotation.X0_Y0, baseVariant.uvLock.orElse(false).booleanValue(), baseVariant.weight.orElse(1).intValue());
        this.state = baseVariant.state.get();
        this.baseVariant = CCFinalMultiVariant.makeFinalVariant(baseVariant, textureDomain);
        this.baseProperties = new ModelProperties(baseVariant.smooth.orElse(true), baseVariant.gui3d.orElse(true));
        for (CCVariant subModel : subModels.values()) {
            this.finalVariants.add(CCFinalMultiVariant.makeFinalVariant(baseVariant.copy().with(subModel), textureDomain));
        }
    }

    public IModel process(IModel base) {
        boolean hasBase;
        boolean bl = hasBase = base != ModelLoaderRegistry.getMissingModel();
        if (hasBase) {
            base = this.baseVariant.process(base);
        }
        LinkedList<IModel> subModels = new LinkedList<IModel>();
        for (Variant variant : this.finalVariants) {
            if (variant.func_188046_a().equals((Object)new ResourceLocation("builtin/missing"))) continue;
            IModel subModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)variant.func_188046_a(), (String)("Unable to load subModel's Model: " + variant.func_188046_a()));
            subModels.add(variant.process((IModel)new StateOverrideIModel(subModel, variant.getState())));
        }
        return new CCMultiModel((IModel)(hasBase ? base : null), this.baseProperties, subModels);
    }

    public IModelState getState() {
        return this.state;
    }

    private static Variant makeFinalVariant(CCVariant variant, String textureDomain) {
        boolean uvLock = variant.uvLock.orElse(false);
        boolean smooth = variant.smooth.orElse(true);
        boolean gui3d = variant.gui3d.orElse(true);
        int weight = variant.weight.orElse(1);
        if (variant.hasModel() && !variant.hasTextures() && !variant.hasCustomData() && variant.state.get() instanceof ModelRotation) {
            return new Variant(variant.model, (ModelRotation)variant.state.get(), uvLock, weight);
        }
        return new CCFinalVariant(variant.model, variant.state, uvLock, smooth, gui3d, weight, variant.textures, textureDomain, variant.customData);
    }
}

