/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model;

import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.LambdaUtils;
import codechicken.lib.util.TransformUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;

public class ItemQuadBakery {
    public static List<BakedQuad> bakeItem(List<TextureAtlasSprite> sprites) {
        return ItemQuadBakery.bakeItem(sprites, DefaultVertexFormats.field_176599_b, TransformUtils.DEFAULT_ITEM);
    }

    public static List<BakedQuad> bakeItem(List<TextureAtlasSprite> sprites, IModelState state) {
        return ItemQuadBakery.bakeItem(sprites, DefaultVertexFormats.field_176599_b, state);
    }

    public static List<BakedQuad> bakeItem(List<TextureAtlasSprite> sprites, VertexFormat format) {
        return ItemQuadBakery.bakeItem(sprites, format, TransformUtils.DEFAULT_ITEM);
    }

    public static List<BakedQuad> bakeItem(List<TextureAtlasSprite> sprites, VertexFormat format, IModelState state) {
        return ItemQuadBakery.bakeItem(format, state, sprites.toArray(new TextureAtlasSprite[0]));
    }

    public static List<BakedQuad> bakeItem(TextureAtlasSprite ... sprites) {
        return ItemQuadBakery.bakeItem(TransformUtils.DEFAULT_ITEM, sprites);
    }

    public static List<BakedQuad> bakeItem(IModelState state, TextureAtlasSprite ... sprites) {
        return ItemQuadBakery.bakeItem(DefaultVertexFormats.field_176599_b, state, sprites);
    }

    public static List<BakedQuad> bakeItem(VertexFormat format, TextureAtlasSprite ... sprites) {
        return ItemQuadBakery.bakeItem(format, TransformUtils.DEFAULT_ITEM, sprites);
    }

    public static List<BakedQuad> bakeItem(VertexFormat format, IModelState state, TextureAtlasSprite ... sprites) {
        LambdaUtils.checkArgument(sprites, "Sprites must not be Null or empty!", ArrayUtils::isNullOrContainsNull);
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        Optional transform = state.apply(Optional.empty());
        for (int i = 0; i < sprites.length; ++i) {
            TextureAtlasSprite sprite = sprites[i];
            quads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)sprite, (VertexFormat)format, (Optional)transform));
        }
        return quads;
    }
}

