/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataInputStream;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.data.MCDataOutputStream;
import com.google.common.base.Charsets;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MCDataUtils {
    public static int readVarInt(MCDataInput in) {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = in.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static int readVarShort(MCDataInput in) {
        int low = in.readUShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = in.readUByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static long readVarLong(MCDataInput in) {
        byte b0;
        long i = 0L;
        int j = 0;
        do {
            b0 = in.readByte();
            i |= (long)(b0 & 0x7F) << j++ * 7;
            if (j <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static String readString(MCDataInput in) {
        return new String(in.readArray(in.readVarInt()), Charsets.UTF_8);
    }

    public static ItemStack readItemStack(MCDataInput in) {
        ItemStack item = ItemStack.field_190927_a;
        short itemID = in.readShort();
        if (itemID >= 0) {
            int stackSize = in.readVarInt();
            short damage = in.readShort();
            item = new ItemStack(Item.func_150899_d((int)itemID), stackSize, (int)damage);
            item.func_77982_d(in.readNBTTagCompound());
        }
        return item;
    }

    public static FluidStack readFluidStack(MCDataInput in) {
        FluidStack fluid = null;
        String fluidName = in.readString();
        if (fluidName.length() > 0) {
            fluid = new FluidStack(FluidRegistry.getFluid((String)fluidName), in.readVarInt(), in.readNBTTagCompound());
        }
        return fluid;
    }

    @Nullable
    public static NBTTagCompound readNBTTagCompound(MCDataInput input) {
        byte flag = input.readByte();
        if (flag == 0) {
            return null;
        }
        if (flag == 1) {
            try {
                return CompressedStreamTools.func_152456_a((DataInput)new DataInputStream(new MCDataInputStream(input)), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
            }
            catch (IOException e) {
                throw new EncoderException((Throwable)e);
            }
        }
        throw new EncoderException("Invalid flag for readNBTTagCompound. Expected 0 || 1 Got: " + flag + " Possible incorrect read order?");
    }

    public static void writeVarInt(MCDataOutput out, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            out.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        out.writeByte(i);
    }

    public static void writeVarShort(MCDataOutput out, int s) {
        int low = s & Short.MAX_VALUE;
        int high = (s & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        out.writeShort(low);
        if (high != 0) {
            out.writeByte(high);
        }
    }

    public static void writeVarLong(MCDataOutput out, long value) {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)(value & 0x7FL) | 0x80);
            value >>>= 7;
        }
        out.writeByte((int)value);
    }

    public static void writeString(MCDataOutput out, String string) {
        byte[] abyte = string.getBytes(Charsets.UTF_8);
        if (abyte.length > Short.MAX_VALUE) {
            throw new EncoderException("String too big (was " + string.length() + " bytes encoded, max " + Short.MAX_VALUE + ")");
        }
        out.writeVarInt(abyte.length);
        out.writeArray(abyte);
    }

    public static void writeItemStack(MCDataOutput out, ItemStack stack) {
        if (stack.func_190926_b()) {
            out.writeShort(-1);
        } else {
            out.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            out.writeVarInt(stack.func_190916_E());
            out.writeShort(stack.func_77952_i());
            out.writeNBTTagCompound(stack.func_77973_b().func_77651_p() ? stack.func_77978_p() : null);
        }
    }

    public static void writeFluidStack(MCDataOutput out, FluidStack fluid) {
        if (fluid == null || FluidRegistry.getFluidName((FluidStack)fluid) == null) {
            out.writeString("");
        } else {
            out.writeString(FluidRegistry.getFluidName((FluidStack)fluid));
            out.writeVarInt(fluid.amount);
            out.writeNBTTagCompound(fluid.tag);
        }
    }

    public static void writeNBTTagCompount(@Nonnull MCDataOutput out, @Nullable NBTTagCompound tag) {
        if (tag == null) {
            out.writeByte(0);
            return;
        }
        try {
            out.writeByte(1);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)new DataOutputStream(new MCDataOutputStream(out)));
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }
}

