/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.recipe;

import de.eydamos.backpack.helper.BackpackHelper;
import de.eydamos.backpack.item.EBackpack;
import de.eydamos.backpack.item.EColor;
import de.eydamos.backpack.item.ESize;
import de.eydamos.backpack.recipe.AbstractRecipe;
import de.eydamos.backpack.recipe.ECategory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;

public class RecipeRecolorBackpack
extends AbstractRecipe {
    private int dyeCol;
    private int dyeRow;
    private int backpackCol;
    private int backpackRow;
    private boolean dyeFound = false;
    private boolean backpackFound = false;

    public RecipeRecolorBackpack() {
        super(2, 1, EBackpack.SMALL.getItemStack(), ECategory.SHAPELESS);
    }

    @Override
    protected boolean checkItemAtPosition(InventoryCrafting craftingGridInventory, int col, int row, int expectedCol, int expectedRow) {
        ItemStack itemStack = craftingGridInventory.func_70463_b(col, row);
        if (itemStack.func_190926_b()) {
            return true;
        }
        if (EColor.isColor(itemStack)) {
            if (!this.dyeFound) {
                this.dyeCol = col;
                this.dyeRow = row;
                this.dyeFound = true;
                return true;
            }
            this.dyeFound = false;
            return false;
        }
        if (BackpackHelper.isBackpack(itemStack)) {
            if (!this.backpackFound) {
                this.backpackCol = col;
                this.backpackRow = row;
                this.backpackFound = true;
                return true;
            }
            this.backpackFound = false;
            return false;
        }
        return false;
    }

    @Override
    protected boolean allRecipeItemsFulfilled() {
        boolean result = this.dyeFound && this.backpackFound;
        this.dyeFound = false;
        this.backpackFound = false;
        return result;
    }

    public ItemStack func_77572_b(InventoryCrafting craftingGridInventory) {
        ItemStack backpack = craftingGridInventory.func_70463_b(this.backpackCol, this.backpackRow).func_77946_l();
        EColor color = EColor.getColor(craftingGridInventory.func_70463_b(this.dyeCol, this.dyeRow));
        ESize size = ESize.getSizeByBackpack(backpack);
        backpack.func_77964_b(size.getDamage() + color.getDamage());
        return backpack;
    }
}

