/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.mj.MjAPI;
import io.netty.buffer.ByteBuf;
import mekanism.api.MekanismAPI;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.FuelHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.config.MekanismConfig;
import mekanism.common.fixers.MekanismDataFixers;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.StackUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.GeneratorsCommonProxy;
import mekanism.generators.common.GeneratorsGuiHandler;
import mekanism.generators.common.GeneratorsItems;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.fixers.GeneratorTEFixer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="mekanismgenerators", useMetadata=true, guiFactory="mekanism.generators.client.gui.GeneratorsGuiFactory", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class MekanismGenerators
implements IModule {
    public static final String MODID = "mekanismgenerators";
    @SidedProxy(clientSide="mekanism.generators.client.GeneratorsClientProxy", serverSide="mekanism.generators.common.GeneratorsCommonProxy")
    public static GeneratorsCommonProxy proxy;
    @Mod.Instance(value="mekanismgenerators")
    public static MekanismGenerators instance;
    public static Version versionNumber;
    public static final int DATA_VERSION = 1;
    public static MultiblockManager<SynchronizedTurbineData> turbineManager;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GeneratorsBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        GeneratorsItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
        GeneratorsBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerBlockRenders();
        proxy.registerItemRenders();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        proxy.loadConfiguration();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        PacketSimpleGui.handlers.add(1, proxy);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GeneratorsGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.registerTileEntities();
        proxy.registerTESRs();
        CompoundDataFixer fixer = FMLCommonHandler.instance().getDataFixer();
        ModFixs fixes = fixer.init(MODID, 1);
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new GeneratorTEFixer(MekanismDataFixers.MekFixers.TILE_ENTITIES));
        Mekanism.logger.info("Loaded MekanismGenerators module.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (FuelHandler.BCPresent() && BuildcraftFuelRegistry.fuel != null) {
            for (IFuel s : BuildcraftFuelRegistry.fuel.getFuels()) {
                if (s.getFluid() == null || GasRegistry.containsGas((String)s.getFluid().getFluid().getName())) continue;
                GasRegistry.register((Gas)new Gas(s.getFluid().getFluid()));
            }
            BuildcraftFuelRegistry.fuel.addFuel(MekanismFluids.Ethene.getFluid(), RFIntegration.toRFAsLong((double)(12L * MjAPI.MJ)), 40000);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        FuelHandler.addGas((Gas)MekanismFluids.Ethene, (int)MekanismConfig.current().general.ETHENE_BURN_TIME.val(), (double)(MekanismConfig.current().general.FROM_H2.val() + MekanismConfig.current().generators.bioGeneration.val() * 2.0 * (double)MekanismConfig.current().general.ETHENE_BURN_TIME.val()));
        for (ItemStack ore : OreDictionary.getOres((String)"dustGold", (boolean)false)) {
            RecipeHandler.addMetallurgicInfuserRecipe((InfuseType)InfuseRegistry.get((String)"CARBON"), (int)10, (ItemStack)StackUtils.size((ItemStack)ore, (int)4), (ItemStack)GeneratorsItems.Hohlraum.getEmptyItem());
        }
    }

    public Version getVersion() {
        return versionNumber;
    }

    public String getName() {
        return "Generators";
    }

    public void writeConfig(ByteBuf dataStream, MekanismConfig config) {
        config.generators.write(dataStream);
    }

    public void readConfig(ByteBuf dataStream, MekanismConfig destConfig) {
        destConfig.generators.read(dataStream);
    }

    public void resetClient() {
        SynchronizedTurbineData.clientRotationMap.clear();
        proxy.setGasGeneratorMaxEnergy();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID) || event.getModID().equals("mekanism")) {
            proxy.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onBlacklistUpdate(MekanismAPI.BoxBlacklistEvent event) {
        MekanismAPI.addBoxBlacklist((Block)GeneratorsBlocks.Generator, (int)5);
        MekanismAPI.addBoxBlacklist((Block)GeneratorsBlocks.Generator, (int)6);
    }

    static {
        versionNumber = new Version(9, 8, 3);
        turbineManager = new MultiblockManager("industrialTurbine");
    }
}

