/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import micdoodle8.mods.galacticraft.api.tile.IColorable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockFluidPipe;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.FluidTankGC;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTransmitter;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFluidPipe
extends TileEntityFluidTransmitter
implements IColorable {
    public FluidTankGC buffer = new FluidTankGC(1000, this);
    private boolean dataRequest = false;
    private AxisAlignedBB renderAABB;

    public TileEntityFluidPipe() {
        super("tile.fluid_pipe.name", 100);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    protected boolean handleInventory() {
        return false;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState != newState) {
            return oldState.func_177230_c() != newState.func_177230_c();
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    @Override
    public boolean canConnect(EnumFacing direction, NetworkType type) {
        TileEntity adjacentTile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, direction);
        if (type == NetworkType.FLUID) {
            if (adjacentTile instanceof IColorable) {
                byte otherCol;
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                IBlockState adjacentTileState = adjacentTile.func_145831_w().func_180495_p(adjacentTile.func_174877_v());
                byte thisCol = this.getColor(state);
                return thisCol == (otherCol = ((IColorable)adjacentTile).getColor(adjacentTileState)) || thisCol == EnumDyeColor.WHITE.func_176767_b() || otherCol == EnumDyeColor.WHITE.func_176767_b();
            }
            return true;
        }
        return false;
    }

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 5;
    }

    @Override
    public boolean isNetworkedTile() {
        return false;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_DATA, GCCoreUtil.getDimensionID(this.field_145850_b), new Object[]{GCCoreUtil.getDimensionID(this.field_145850_b), this.func_174877_v()}));
        }
    }

    @Override
    public void onColorUpdate() {
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175679_n(this.func_174877_v());
            } else {
                this.getNetwork().split(this);
                this.resetNetwork();
            }
        }
    }

    @Override
    public byte getColor(IBlockState state) {
        if (state.func_177230_c() instanceof BlockFluidPipe) {
            return (byte)((EnumDyeColor)state.func_177229_b(BlockFluidPipe.COLOR)).func_176767_b();
        }
        return 15;
    }

    @Override
    public void onAdjacentColorChanged(EnumFacing direction) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        if (!this.field_145850_b.field_72995_K) {
            this.refresh();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.buffer.getFluid() != null) {
            tagCompound.func_74782_a("buff", (NBTBase)this.buffer.writeToNBT(new NBTTagCompound()));
        }
        return tagCompound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("pipeColor")) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockFluidPipe.COLOR, (Comparable)EnumDyeColor.func_176766_a((int)tagCompound.func_74771_c("pipeColor"))));
        }
        if (tagCompound.func_74764_b("buff")) {
            this.buffer.readFromNBT(tagCompound.func_74775_l("buff"));
        }
    }

    @Override
    public FluidStack getBuffer() {
        return this.buffer.getFluid() == null ? null : this.buffer.getFluid();
    }

    @Override
    public int getCapacity() {
        return 200;
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        IGridNetwork network = this.getNetwork();
        if (network instanceof FluidNetwork) {
            FluidNetwork fluidNetwork = (FluidNetwork)network;
            return fluidNetwork.emitToBuffer(resource, doFill);
        }
        return this.buffer.fill(resource, doFill);
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[0];
    }

    public boolean switchType() {
        Block block;
        if (this.ticks < 10) {
            return false;
        }
        Block currentType = this.func_145838_q();
        if (!(currentType instanceof BlockFluidPipe)) {
            return false;
        }
        switch (((BlockFluidPipe)currentType).getMode()) {
            case NORMAL: {
                block = GCBlocks.oxygenPipePull;
                break;
            }
            default: {
                block = GCBlocks.oxygenPipe;
            }
        }
        BlockFluidPipe.ignoreDrop = true;
        this.field_145850_b.func_175656_a(this.field_174879_c, block.func_176203_a(currentType.func_176201_c(this.field_145850_b.func_180495_p(this.field_174879_c))));
        BlockFluidPipe.ignoreDrop = false;
        if (this.hasNetwork()) {
            this.refresh();
            this.getNetwork().refresh();
        }
        return true;
    }

    @Override
    public boolean canTransmit() {
        Block currentType = this.func_145838_q();
        if (!(currentType instanceof BlockFluidPipe)) {
            return true;
        }
        return ((BlockFluidPipe)currentType).getMode() != BlockFluidPipe.EnumPipeMode.PULL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        String mekGas = stack.getGas().getName();
        if (mekGas == null) {
            return 0;
        }
        FluidStack mekEquivalent = null;
        if (mekGas.equals("oxygen")) {
            mekEquivalent = new FluidStack(GCFluids.fluidOxygenGas, stack.amount);
        } else if (mekGas.equals("hydrogen")) {
            mekEquivalent = new FluidStack(GCFluids.fluidHydrogenGas, stack.amount);
        } else {
            return 0;
        }
        return this.fill(side, mekEquivalent, doTransfer);
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public GasStack drawGas(EnumFacing side, int amount) {
        return null;
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return type.getName().equals("oxygen") || type.getName().equals("hydrogen");
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.ITubeConnection", modID="mekanism")
    public boolean canTubeConnect(EnumFacing side) {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (EnergyUtil.checkMekGasHandler(capability)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, facing);
        }
        if (EnergyUtil.checkMekGasHandler(capability)) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }
}

