/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.util.List;
import net.machinemuse.numina.client.gui.frame.IGuiFrame;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.math.MuseMathUtils;
import net.machinemuse.numina.math.geometry.DrawableMuseRect;
import net.machinemuse.numina.math.geometry.MusePoint2D;
import net.machinemuse.powersuits.client.model.item.armor.ArmorModelInstance;
import net.machinemuse.powersuits.client.model.item.armor.IArmorModel;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableItem;
import net.machinemuse.powersuits.gui.tinker.frame.ItemSelectionFrame;
import net.machinemuse.powersuits.item.armor.ItemPowerArmor;
import net.machinemuse.powersuits.item.tool.ItemPowerFist;
import net.machinemuse.powersuits.utils.nbt.MPSNBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Mouse;

public class PlayerModelViewFrame
implements IGuiFrame {
    ItemSelectionFrame itemSelector;
    DrawableMuseRect border;
    double anchorx = 0.0;
    double anchory = 0.0;
    int dragging = -1;
    double lastdWheel = 0.0;
    double rotx = 0.0;
    double roty = 0.0;
    double offsetx = 0.0;
    double offsety = 29.0;
    double zoom = 30.0;
    int mouseX = 0;
    int mouseY = 0;
    private float oldMouseX = 20.0f;
    private float oldMouseY = 20.0f;

    public PlayerModelViewFrame(ItemSelectionFrame itemSelector, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        this.itemSelector = itemSelector;
        this.border = new DrawableMuseRect(topleft, bottomright, borderColour, insideColour);
    }

    EntityEquipmentSlot getEquipmentSlot() {
        ItemStack selectedItem = this.getSelectedItem().getItem();
        if (selectedItem != null && selectedItem.func_77973_b() instanceof ItemPowerArmor) {
            return ((ItemPowerArmor)selectedItem.func_77973_b()).field_77881_a;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack heldItem = player.func_184592_cb();
        if (!heldItem.func_190926_b() && MuseItemUtils.stackEqualExact((ItemStack)selectedItem, (ItemStack)heldItem)) {
            return EntityEquipmentSlot.OFFHAND;
        }
        return EntityEquipmentSlot.MAINHAND;
    }

    ClickableItem getSelectedItem() {
        return this.itemSelector.getSelectedItem();
    }

    NBTTagCompound getRenderTag() {
        return MPSNBTUtils.getMuseRenderTag(this.getSelectedItem().getItem(), this.getEquipmentSlot());
    }

    public void onMouseDown(double x, double y, int button) {
        if (this.border.containsPoint(x, y)) {
            this.dragging = button;
            this.anchorx = x;
            this.anchory = y;
        }
    }

    public void onMouseUp(double x, double y, int button) {
        this.dragging = -1;
    }

    public void update(double mousex, double mousey) {
        if ((double)this.mouseX != mousex) {
            this.oldMouseX = this.mouseX;
        }
        this.mouseX = (int)mousex;
        if ((double)this.mouseY != mousey) {
            this.oldMouseY = this.mouseY;
        }
        this.mouseY = (int)mousey;
        if (this.border.containsPoint(mousex, mousey)) {
            double dscroll = (this.lastdWheel - (double)Mouse.getDWheel()) / 120.0;
            this.zoom *= Math.pow(1.1, dscroll);
            this.lastdWheel = Mouse.getDWheel();
        }
        double dx = mousex - this.anchorx;
        double dy = mousey - this.anchory;
        switch (this.dragging) {
            case 0: {
                this.rotx = MuseMathUtils.clampDouble((double)(this.rotx + dy), (double)-90.0, (double)90.0);
                this.roty -= dx;
                this.anchorx = mousex;
                this.anchory = mousey;
                break;
            }
            case 1: {
                this.offsetx += dx;
                this.offsety += dy;
                this.anchorx = mousex;
                this.anchory = mousey;
                break;
            }
        }
    }

    public void draw() {
        Minecraft mc = Minecraft.func_71410_x();
        this.border.draw();
        if (this.itemSelector.getSelectedItem() == null) {
            return;
        }
        if (this.getSelectedItem().getItem().func_77973_b() instanceof ItemPowerArmor) {
            ((IArmorModel)ArmorModelInstance.getInstance()).setRenderSpec(MPSNBTUtils.getMuseRenderTag(this.getSelectedItem().getItem(), this.getEquipmentSlot()));
            ((IArmorModel)ArmorModelInstance.getInstance()).setVisibleSection(this.getEquipmentSlot());
        } else if (this.getSelectedItem().getItem().func_77973_b() instanceof ItemPowerFist) {
            MPSNBTUtils.getMuseRenderTag(this.getSelectedItem().getItem(), this.getEquipmentSlot());
        } else {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float mouseX = (float)(this.border.left() + 51.0) - this.oldMouseX;
        float mouseY = (float)((int)this.border.top() + 75 - 50) - this.oldMouseY;
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(this.border.centerx() + this.offsetx), (double)(this.border.centery() + this.offsety), (double)50.0);
        GlStateManager.func_179152_a((float)((float)(-this.zoom)), (float)((float)this.zoom), (float)((float)this.zoom));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = mc.field_71439_g.field_70761_aq;
        float f1 = mc.field_71439_g.field_70177_z;
        float f2 = mc.field_71439_g.field_70125_A;
        float f3 = mc.field_71439_g.field_70758_at;
        float f4 = mc.field_71439_g.field_70759_as;
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotx), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.roty), (float)0.0f, (float)1.0f, (float)0.0f);
        mc.field_71439_g.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        mc.field_71439_g.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        mc.field_71439_g.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        mc.field_71439_g.field_70759_as = mc.field_71439_g.field_70177_z;
        mc.field_71439_g.field_70758_at = mc.field_71439_g.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)mc.field_71439_g, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        mc.field_71439_g.field_70761_aq = f;
        mc.field_71439_g.field_70177_z = f1;
        mc.field_71439_g.field_70125_A = f2;
        mc.field_71439_g.field_70758_at = f3;
        mc.field_71439_g.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public List<String> getToolTip(int x, int y) {
        return null;
    }
}

