/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.util;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.lib.util.IntegrationConfigOptions;
import com.mcmoddev.lib.util.MaterialConfigOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class Config {
    private static final String FLUIDS_CAT = "Fluids";
    private static final String MATERIALS_CAT = "Metals";
    private static final String VANILLA_CAT = "Vanilla";
    private static final String INTEGRATION_CAT = "Mod Integration";
    private static final String FORCED_TRAIT_CAT = "Forced Traits";
    private static final List<String> UserCrusherRecipes = new ArrayList<String>();

    protected Config() {
    }

    private static void integrationEnabled(String identifier, String modid, Boolean defaultValue, Configuration configuration) {
        String newIdentifier = WordUtils.capitalizeFully((String)identifier);
        Options.modEnabled(modid, configuration.getBoolean(modid + "_integration", INTEGRATION_CAT, defaultValue.booleanValue(), "If false, then Base Metals will not try and integrate with " + newIdentifier));
    }

    protected static void configIntegrationOptions(IntegrationConfigOptions[] integrationConfigOptions, Configuration configuration) {
        for (IntegrationConfigOptions integration : integrationConfigOptions) {
            Config.integrationEnabled(integration.getIdentifier(), integration.getModid(), integration.getEnabled(), configuration);
        }
    }

    private static void forceTraitRegistration(String identifier, Boolean hasTraits, Boolean defaultValue, Configuration configuration) {
        if (hasTraits.booleanValue()) {
            String newIdentifier = WordUtils.capitalizeFully((String)identifier);
            Options.forcedTrait(identifier, configuration.getBoolean("Force" + newIdentifier + "TraitRegistration", FORCED_TRAIT_CAT, defaultValue.booleanValue(), "Enable the forced registration of traits for " + identifier));
        }
    }

    private static void fluidEnabled(String identifier, Boolean defaultValue, Configuration configuration) {
        String newIdentifier = WordUtils.capitalizeFully((String)identifier);
        Options.fluidEnabled(identifier, configuration.getBoolean("Enabled " + newIdentifier, FLUIDS_CAT, defaultValue.booleanValue(), "Enable the molten fluid of " + identifier));
    }

    private static void materialEnabled(String identifier, Boolean defaultValue, Boolean isVanilla, Configuration configuration) {
        String newIdentifier = WordUtils.capitalizeFully((String)identifier);
        String cat = isVanilla != false ? VANILLA_CAT : MATERIALS_CAT;
        String comment = isVanilla != false ? " Additions like Walls, Slabs and Pressure-plates" : " Items and Materials";
        Options.materialEnabled(identifier, configuration.getBoolean("Enable" + newIdentifier, cat, defaultValue.booleanValue(), "Enable " + newIdentifier + comment));
    }

    protected static void configMaterialOptions(MaterialConfigOptions[] materials, Configuration configuration) {
        for (MaterialConfigOptions materialConfigOptions : materials) {
            Config.materialEnabled(materialConfigOptions.getIdentifier(), materialConfigOptions.getMaterialEnabled(), materialConfigOptions.getVanilla(), configuration);
            if (materialConfigOptions.getHasFluid().booleanValue()) {
                Config.fluidEnabled(materialConfigOptions.getIdentifier(), materialConfigOptions.getFluidEnabled(), configuration);
            }
            Config.forceTraitRegistration(materialConfigOptions.getIdentifier(), materialConfigOptions.getHasTraits(), materialConfigOptions.getForceTraits(), configuration);
        }
    }

    protected static void manageUserHammerRecipes(Collection<Property> values) {
        for (Property p : values) {
            String[] recipes;
            for (String r : recipes = p.getString().split(";")) {
                String recipe = r.trim();
                if (recipe.isEmpty()) continue;
                if (!recipe.contains("->")) {
                    throw new IllegalArgumentException("Malformed hammer recipe expression '" + recipe + "'. Should be in format 'modid:itemname->modid:itemname'");
                }
                UserCrusherRecipes.add(recipe);
            }
        }
    }

    protected static String[] parseDisabledRecipes(String rawDisabledRecipes) {
        if (!rawDisabledRecipes.isEmpty() && rawDisabledRecipes.contains(";")) {
            return rawDisabledRecipes.split(";");
        }
        return new String[]{rawDisabledRecipes};
    }

    public static void postInit() {
        Config.addUserRecipes();
        if (Options.autoDetectRecipes()) {
            HashSet<String> dictionary = new HashSet<String>();
            dictionary.addAll(Arrays.asList(OreDictionary.getOreNames()).stream().filter(item -> !item.contains("Mercury")).filter(item -> !item.contains("Redstone")).filter(item -> item.startsWith("dust")).filter(item -> {
                String ingotX = "ingot".concat(item.substring(4));
                String oreX = "ore".concat(item.substring(4));
                return dictionary.contains(oreX) && dictionary.contains(ingotX) && !OreDictionary.getOres((String)item).isEmpty();
            }).collect(Collectors.toSet()));
            Config.addOreRecipes(dictionary);
            Config.addIngotRecipes(dictionary);
        }
    }

    private static void addIngotRecipes(Set<String> dictionary) {
        dictionary.stream().filter(entry -> {
            NonNullList itemstacks = OreDictionary.getOres((String)"ingot".concat(entry.substring(4)));
            for (ItemStack i : itemstacks) {
                if (CrusherRecipeRegistry.getRecipeForInputItem(i) == null) continue;
                return true;
            }
            return false;
        }).forEach(entry -> {
            String ingotX = "ingot".concat(entry.substring(4));
            ItemStack dustX = ((ItemStack)OreDictionary.getOres((String)entry).get(0)).func_77946_l();
            dustX.func_190920_e(2);
            MMDLib.logger.info("Automatically adding custom crusher recipe '{}' -> {}", (Object)ingotX, (Object)dustX);
            CrusherRecipeRegistry.addNewCrusherRecipe(ingotX, dustX);
        });
    }

    private static void addOreRecipes(Set<String> dictionary) {
        dictionary.stream().filter(entry -> {
            NonNullList itemstacks = OreDictionary.getOres((String)"ore".concat(entry.substring(4)));
            for (ItemStack i : itemstacks) {
                if (CrusherRecipeRegistry.getRecipeForInputItem(i) == null) continue;
                return true;
            }
            return false;
        }).forEach(entry -> {
            String oreX = "ore".concat(entry.substring(4));
            ItemStack dustX = ((ItemStack)OreDictionary.getOres((String)entry).get(0)).func_77946_l();
            dustX.func_190920_e(2);
            MMDLib.logger.info("Automatically adding custom crusher recipe '{}' -> {}", (Object)oreX, (Object)dustX);
            CrusherRecipeRegistry.addNewCrusherRecipe(oreX, dustX);
        });
    }

    private static void addUserRecipes() {
        for (String recipe : UserCrusherRecipes) {
            MMDLib.logger.info("Adding custom crusher recipe '{}'", (Object)recipe);
            int i = recipe.indexOf("->");
            String inputStr = recipe.substring(0, i);
            String outputStr = recipe.substring(i + 2, recipe.length());
            ItemStack input = Config.parseStringAsItemStack(inputStr, true);
            ItemStack output = Config.parseStringAsItemStack(outputStr, false);
            if (input.func_190926_b() || output.func_190926_b()) {
                MMDLib.logger.error("Failed to add recipe formula '{}' because the blocks/items could not be found", (Object)recipe);
                continue;
            }
            CrusherRecipeRegistry.addNewCrusherRecipe(input, output);
        }
    }

    public static ItemStack parseStringAsItemStack(String str, boolean allowWildcard) {
        String id;
        String work = str.trim();
        int count = 1;
        int meta = allowWildcard ? Short.MAX_VALUE : 0;
        int nameStart = 0;
        int nameEnd = work.length();
        if (work.contains("*")) {
            count = Integer.parseInt(work.substring(0, work.indexOf(42)).trim());
            nameStart = work.indexOf(42) + 1;
        }
        if (work.contains("#")) {
            meta = Integer.parseInt(work.substring(work.indexOf(35) + 1, str.length()).trim());
            nameEnd = work.indexOf(35);
        }
        if (Block.func_149684_b((String)(id = work.substring(nameStart, nameEnd).trim())) != null) {
            return new ItemStack(Block.func_149684_b((String)id), count, meta);
        }
        if (Item.func_111206_d((String)id) != null) {
            return new ItemStack(Item.func_111206_d((String)id), count, meta);
        }
        MMDLib.logger.info("Failed to find item or block for ID '{}'", (Object)id);
        return ItemStack.field_190927_a;
    }

    public static class Options {
        private static boolean disableAllHammerRecipes = false;
        private static boolean enforceHardness = true;
        private static boolean strongHammers = true;
        private static boolean twoDustDrop = true;
        private static boolean autoDetectRecipes = true;
        private static boolean requireMMDOreSpawn = true;
        private static boolean enableAchievements = true;
        private static boolean crackHammerFullStack = false;
        private static boolean enableShieldUpgrades = true;
        private static boolean enablePlateRepairs = true;
        private static boolean enableModderSupportThings = true;
        private static int gearQuantity = 4;
        private static int plateQuantity = 3;
        private static boolean furnaceCheese = true;
        private static boolean furnace1112 = true;
        private static int rodQuantity = 4;
        private static int explosionChance = 0;
        private static int angerPigmenRange = 0;
        private static final Map<String, Boolean> modEnabled = new HashMap<String, Boolean>();
        private static final Map<String, Boolean> materialEnabled = new HashMap<String, Boolean>();
        private static final Map<String, Boolean> thingEnabled = new HashMap<String, Boolean>();
        private static final Map<String, Boolean> fluidEnabled = new HashMap<String, Boolean>();
        private static String[] disabledRecipes = null;
        private static final Map<String, Boolean> forcedTrait = new HashMap<String, Boolean>();
        private static boolean fallbackOrespawn;

        public static void setDisableAllHammerRecipes(boolean bool) {
            disableAllHammerRecipes = bool;
        }

        public static void setEnforceHardness(boolean bool) {
            enforceHardness = bool;
        }

        public static void setStrongHammers(boolean bool) {
            strongHammers = bool;
        }

        public static void setTwoDustDrop(boolean bool) {
            twoDustDrop = bool;
        }

        public static void setAutoDetectRecipes(boolean bool) {
            autoDetectRecipes = bool;
        }

        public static void setRequireMMDOreSpawn(boolean bool) {
            requireMMDOreSpawn = bool;
        }

        public static void setEnableAchievements(boolean bool) {
            enableAchievements = bool;
        }

        public static void setCrackHammerFullStack(boolean bool) {
            crackHammerFullStack = bool;
        }

        public static void setEnableShieldUpgrades(boolean bool) {
            enableShieldUpgrades = bool;
        }

        public static void setEnablePlateRepairs(boolean bool) {
            enablePlateRepairs = bool;
        }

        public static void setEnableModderSupportThings(boolean bool) {
            enableModderSupportThings = bool;
        }

        public static boolean disableAllHammerRecipes() {
            return disableAllHammerRecipes;
        }

        public static boolean enforceHardness() {
            return enforceHardness;
        }

        public static boolean strongHammers() {
            return strongHammers;
        }

        public static boolean twoDustDrop() {
            return twoDustDrop;
        }

        public static boolean autoDetectRecipes() {
            return autoDetectRecipes;
        }

        public static boolean requireMMDOreSpawn() {
            return requireMMDOreSpawn;
        }

        public static boolean enableAchievements() {
            return enableAchievements;
        }

        public static boolean crackHammerFullStack() {
            return crackHammerFullStack;
        }

        public static boolean enableShieldUpgrades() {
            return enableShieldUpgrades;
        }

        public static boolean enablePlateRepairs() {
            return enablePlateRepairs;
        }

        public static boolean enableModderSupportThings() {
            return enableModderSupportThings;
        }

        public static void setDisabledRecipes(String[] string) {
            disabledRecipes = string;
            Arrays.asList(disabledRecipes).stream().forEach(CrusherRecipeRegistry::disableRecipe);
        }

        public static String[] disabledRecipes() {
            return disabledRecipes;
        }

        public static void setGearQuantity(int qty) {
            gearQuantity = qty;
        }

        public static int gearQuantity() {
            return gearQuantity;
        }

        public static void setPlateQuantity(int qty) {
            plateQuantity = qty;
        }

        public static int plateQuantity() {
            return plateQuantity;
        }

        public static void setFurnaceCheese(boolean bool) {
            furnaceCheese = bool;
        }

        public static boolean furnaceCheese() {
            return furnaceCheese;
        }

        public static void setFurnace1112(boolean bool) {
            furnace1112 = bool;
        }

        public static boolean furnace1112() {
            return furnace1112;
        }

        protected static void clearOptions() {
            modEnabled.clear();
            materialEnabled.clear();
            thingEnabled.clear();
            fluidEnabled.clear();
        }

        public static boolean isModEnabled(String modName) {
            String testName = modName.toLowerCase(Locale.ROOT);
            if (modEnabled.containsKey(testName)) {
                return modEnabled.get(testName);
            }
            return false;
        }

        public static void modEnabled(String modName, Boolean bool) {
            if (!modEnabled.containsKey(modName)) {
                modEnabled.put(modName.toLowerCase(Locale.ROOT), bool);
            }
        }

        public static boolean isMaterialEnabled(String name) {
            String testName = name.toLowerCase(Locale.ROOT);
            if (materialEnabled.containsKey(testName)) {
                return materialEnabled.get(testName);
            }
            return false;
        }

        public static void materialEnabled(String materialName, Boolean bool) {
            if (!materialEnabled.containsKey(materialName)) {
                materialEnabled.put(materialName.toLowerCase(Locale.ROOT), bool);
            }
        }

        public static boolean isThingEnabled(String name) {
            String testName = name.toLowerCase(Locale.ROOT);
            if (thingEnabled.containsKey(testName)) {
                return thingEnabled.get(testName);
            }
            return false;
        }

        public static void thingEnabled(String name, Boolean bool) {
            if (!thingEnabled.containsKey(name)) {
                thingEnabled.put(name.toLowerCase(Locale.ROOT), bool);
            }
        }

        public static boolean isFluidEnabled(String name) {
            String testName = name.toLowerCase(Locale.ROOT);
            if (fluidEnabled.containsKey(testName)) {
                return fluidEnabled.get(testName);
            }
            return false;
        }

        public static boolean isForcedTrait(String name) {
            String testName = name.toLowerCase(Locale.ROOT);
            if (forcedTrait.containsKey(testName)) {
                return forcedTrait.get(testName);
            }
            return false;
        }

        public static void fluidEnabled(String name, Boolean bool) {
            if (!fluidEnabled.containsKey(name)) {
                fluidEnabled.put(name.toLowerCase(Locale.ROOT), bool);
            }
        }

        public static void forcedTrait(String name, Boolean bool) {
            if (!forcedTrait.containsKey(name)) {
                forcedTrait.put(name.toLowerCase(Locale.ROOT), bool);
            }
        }

        public static int explosionChance() {
            return explosionChance;
        }

        public static void explosionChance(int chance) {
            explosionChance = chance;
        }

        public static int angerPigmenRange() {
            return angerPigmenRange;
        }

        public static void angerPigmenRange(int range) {
            angerPigmenRange = range;
        }

        protected Options() {
            throw new IllegalAccessError("Not a instantiable class");
        }

        public static void setFallbackOreSpawn(boolean boolean1) {
            fallbackOrespawn = boolean1;
        }

        public static boolean fallbackOrespawn() {
            return fallbackOrespawn;
        }

        public static void setRodQuantity(int quantity) {
            rodQuantity = quantity;
        }

        public static int rodQuantity() {
            return rodQuantity;
        }
    }
}

