/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.registry.recipe;

import com.mcmoddev.lib.registry.recipe.ICrusherNBTRecipe;
import com.mcmoddev.lib.registry.recipe.ICrusherRecipe;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NBTCrusherRecipe
extends IForgeRegistryEntry.Impl<ICrusherRecipe>
implements ICrusherRecipe,
ICrusherNBTRecipe {
    private final OutputMunger outputCallback;
    private final InputMunger inputCallback;
    private final Predicate<ItemStack> validItemCallback;
    private final ItemStack inputItem;

    public NBTCrusherRecipe(ItemStack input, OutputMunger nbtCallback, InputMunger inputCallback, Predicate<ItemStack> validItemCallback) {
        this.inputItem = input;
        this.outputCallback = nbtCallback;
        this.inputCallback = inputCallback;
        this.validItemCallback = validItemCallback;
    }

    public NBTCrusherRecipe(ItemStack input, OutputMunger nbtCallback, InputMunger inputCallback) {
        this(input, nbtCallback, inputCallback, in -> OreDictionary.itemMatches((ItemStack)input, (ItemStack)in, (boolean)false));
    }

    public NBTCrusherRecipe(ItemStack input, OutputMunger nbtCallback, Predicate<ItemStack> validItemCallback) {
        this(input, nbtCallback, in -> Arrays.asList(in), validItemCallback);
    }

    public NBTCrusherRecipe(ItemStack input, OutputMunger nbtCallback) {
        this(input, nbtCallback, in -> Arrays.asList(in), in -> OreDictionary.itemMatches((ItemStack)input, (ItemStack)in, (boolean)false));
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.inputCallback.run(this.inputItem);
    }

    @Override
    public ItemStack getOutput() {
        return this.getOutput(this.getInputs().get(0));
    }

    @Override
    public ItemStack getOutput(ItemStack input) {
        return this.isValidInput(input) ? this.outputCallback.run(input) : ItemStack.field_190927_a;
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return this.validItemCallback.test(input);
    }

    @Override
    public Collection<ItemStack> getValidInputs() {
        return Collections.unmodifiableList(this.getInputs());
    }

    public static interface InputMunger {
        public List<ItemStack> run(ItemStack var1);
    }

    public static interface OutputMunger {
        public ItemStack run(ItemStack var1);
    }
}

