/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.registry;

import com.google.common.collect.Lists;
import com.mcmoddev.lib.registry.recipe.ArbitraryCrusherRecipe;
import com.mcmoddev.lib.registry.recipe.ICrusherRecipe;
import com.mcmoddev.lib.registry.recipe.OreDictionaryCrusherRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryBuilder;

public class CrusherRecipeRegistry {
    private final IForgeRegistryModifiable<ICrusherRecipe> registry = (IForgeRegistryModifiable)new RegistryBuilder().setName(new ResourceLocation("mmdlib", "crusher_registry")).allowModification().setType(ICrusherRecipe.class).setMaxID(0x7FFFFFF).create();
    private static final CrusherRecipeRegistry instance = new CrusherRecipeRegistry();
    private final List<String> disabledRecipes = new ArrayList<String>();

    private CrusherRecipeRegistry() {
    }

    public static void disableRecipe(@Nonnull String oreDict) {
        if (!CrusherRecipeRegistry.instance.disabledRecipes.contains(oreDict)) {
            CrusherRecipeRegistry.instance.disabledRecipes.add(oreDict);
        }
    }

    public static void addNewCrusherRecipe(@Nonnull String oreDict, @Nonnull ItemStack output) {
        if (!CrusherRecipeRegistry.instance.disabledRecipes.contains(oreDict)) {
            instance.register(new OreDictionaryCrusherRecipe(oreDict, output));
        }
    }

    public static void addNewCrusherRecipe(@Nonnull Block input, @Nonnull ItemStack output) {
        if (CrusherRecipeRegistry.recipeAllowed(input)) {
            instance.register(new ArbitraryCrusherRecipe(input, output));
        }
    }

    public static void addNewCrusherRecipe(@Nonnull ItemStack input, @Nonnull ItemStack output) {
        if (CrusherRecipeRegistry.recipeAllowed(input)) {
            instance.register(new ArbitraryCrusherRecipe(input, output));
        }
    }

    public static void addNewCrusherRecipe(@Nonnull Item input, @Nonnull ItemStack output) {
        if (CrusherRecipeRegistry.recipeAllowed(new ItemStack(input))) {
            instance.register(new ArbitraryCrusherRecipe(input, output));
        }
    }

    private static boolean recipeAllowed(Block input) {
        return CrusherRecipeRegistry.recipeAllowed(new ItemStack(Item.func_150898_a((Block)input)));
    }

    private static boolean recipeAllowed(ItemStack input) {
        ArrayList items = new ArrayList();
        CrusherRecipeRegistry.instance.disabledRecipes.stream().forEach(oreDict -> items.addAll(OreDictionary.getOres((String)oreDict)));
        if (items.isEmpty()) {
            return true;
        }
        return items.contains(input);
    }

    public void register(@Nonnull ICrusherRecipe recipe) {
        this.registry.register((IForgeRegistryEntry)recipe);
    }

    public static List<ICrusherRecipe> getAll() {
        return Lists.newArrayList((Iterator)CrusherRecipeRegistry.instance.registry.iterator());
    }

    public static CrusherRecipeRegistry getInstance() {
        return instance;
    }

    public void clearCache() {
    }

    public static ICrusherRecipe getRecipeForInputItem(@Nonnull ItemStack itemStack) {
        for (ICrusherRecipe cur : CrusherRecipeRegistry.instance.registry) {
            if (!cur.isValidInput(itemStack)) continue;
            return cur;
        }
        return null;
    }

    public static ResourceLocation getNameForInputItem(@Nonnull ItemStack itemStack) {
        ICrusherRecipe r = CrusherRecipeRegistry.getRecipeForInputItem(itemStack);
        if (r != null) {
            return CrusherRecipeRegistry.instance.registry.getKey((IForgeRegistryEntry)r);
        }
        return new ResourceLocation("");
    }

    public static void removeByName(@Nonnull ResourceLocation name) {
        instance.remove(name);
    }

    public static void removeByInput(@Nonnull String oreDictName) {
        NonNullList itemStacks = OreDictionary.getOres((String)oreDictName);
        for (ItemStack itemStack : itemStacks) {
            CrusherRecipeRegistry.removeByName(CrusherRecipeRegistry.getNameForInputItem(itemStack));
        }
    }

    public static void removeByInput(@Nonnull Item input) {
        CrusherRecipeRegistry.removeByInput(new ItemStack(input));
    }

    public static void removeByInput(@Nonnull Block input) {
        CrusherRecipeRegistry.removeByInput(Item.func_150898_a((Block)input));
    }

    public static void removeByInput(@Nonnull ItemStack input) {
        CrusherRecipeRegistry.removeByName(CrusherRecipeRegistry.getNameForInputItem(input));
    }

    public void remove(@Nonnull ResourceLocation name) {
        this.registry.remove(name);
    }

    public IForgeRegistryModifiable<ICrusherRecipe> getRegistry() {
        return this.registry;
    }
}

