/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.recipe;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.MaterialStats;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeRepairItem;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class ShieldUpgradeRecipe
extends RecipeRepairItem {
    private final String materialName;

    public ShieldUpgradeRecipe(MMDMaterial input) {
        this.materialName = input.getName();
    }

    public boolean func_77569_a(InventoryCrafting inv, @Nullable World worldIn) {
        NonNullList upgradeMats = NonNullList.func_191196_a();
        Collection<MMDMaterial> allmats = Materials.getAllMaterials();
        MMDMaterial input = Materials.getMaterialByName(this.materialName);
        ItemStack base = new ItemStack(input.getItem(Names.SHIELD), 1, 0);
        for (MMDMaterial mat : allmats) {
            if (!(mat.getStat(MaterialStats.HARDNESS) >= input.getStat(MaterialStats.HARDNESS)) || !mat.getName().equals(this.materialName)) continue;
            NonNullList mats = OreDictionary.getOres((String)("plate" + mat.getCapitalizedName()));
            upgradeMats.addAll((Collection)mats);
        }
        boolean[] matches = new boolean[]{false, false};
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack curItem = inv.func_70301_a(i);
            if (curItem.func_190926_b()) continue;
            ItemStack comp = new ItemStack(curItem.func_77973_b(), 1, curItem.func_77952_i());
            if (OreDictionary.itemMatches((ItemStack)base, (ItemStack)comp, (boolean)false)) {
                matches[0] = true;
                continue;
            }
            if (!OreDictionary.containsMatch((boolean)false, (NonNullList)upgradeMats, (ItemStack[])new ItemStack[]{comp})) continue;
            matches[1] = true;
        }
        return matches[0] ? matches[1] : false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        Map<String, NonNullList<ItemStack>> plates = this.getPlates();
        Pair<Map<Enchantment, Integer>, ItemStack> matchedBits = Pair.of(Collections.emptyMap(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack curItem = inv.func_70301_a(i);
            if (curItem.func_190926_b()) continue;
            matchedBits = this.matchAndFind(curItem, plates);
        }
        MMDLib.logger.debug("Adding %d enchantments to output item", (Object)((Map)matchedBits.getLeft()).size());
        if (!((ItemStack)matchedBits.getRight()).func_190926_b()) {
            EnchantmentHelper.func_82782_a((Map)((Map)matchedBits.getLeft()), (ItemStack)((ItemStack)matchedBits.getRight()));
        }
        return (ItemStack)matchedBits.getRight();
    }

    private Pair<Map<Enchantment, Integer>, ItemStack> matchAndFind(ItemStack curItem, Map<String, NonNullList<ItemStack>> plates) {
        ItemStack comp = new ItemStack(curItem.func_77973_b(), 1, curItem.func_77960_j());
        Map enchants = Collections.emptyMap();
        ItemStack plateMatched = ItemStack.field_190927_a;
        ItemStack matcher = new ItemStack(Materials.getMaterialByName(this.materialName).getItem(Names.SHIELD), 1, 0);
        for (Map.Entry<String, NonNullList<ItemStack>> ent : plates.entrySet()) {
            if (!OreDictionary.containsMatch((boolean)false, ent.getValue(), (ItemStack[])new ItemStack[]{comp})) continue;
            plateMatched = new ItemStack(Materials.getMaterialByName(ent.getKey().toLowerCase(Locale.ROOT)).getItem(Names.SHIELD), 1, 0);
        }
        if (OreDictionary.itemMatches((ItemStack)matcher, (ItemStack)comp, (boolean)false)) {
            enchants = EnchantmentHelper.func_82781_a((ItemStack)curItem);
        }
        return Pair.of((Object)enchants, (Object)plateMatched);
    }

    private Map<String, NonNullList<ItemStack>> getPlates() {
        Collection<MMDMaterial> allmats = Materials.getAllMaterials();
        int hardness = Float.valueOf(Materials.getMaterialByName(this.materialName).getStat(MaterialStats.HARDNESS)).intValue();
        TreeMap<String, NonNullList<ItemStack>> plates = new TreeMap<String, NonNullList<ItemStack>>();
        for (MMDMaterial mat : allmats) {
            if (!(mat.getStat(MaterialStats.HARDNESS) >= (float)hardness) || mat.getName().equals(this.materialName)) continue;
            NonNullList mats = OreDictionary.getOres((String)("plate" + mat.getCapitalizedName()));
            plates.put(mat.getName(), (NonNullList<ItemStack>)mats);
        }
        return plates;
    }

    private MMDMaterial getUpgradeMat(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack curItem = inv.func_70301_a(i);
            if (curItem.func_190926_b()) continue;
            for (MMDMaterial e : Materials.getAllMaterials()) {
                if (!OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)("plate" + e.getName())), (ItemStack[])new ItemStack[]{curItem})) continue;
                return e;
            }
        }
        return Materials.getMaterialByName(this.materialName);
    }

    private ItemStack findBaseItem(InventoryCrafting inv) {
        ItemStack input = new ItemStack(Materials.getMaterialByName(this.materialName).getItem(Names.SHIELD), 1, 0);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack comp;
            ItemStack a = inv.func_70301_a(i);
            if (a.func_190926_b() || !OreDictionary.itemMatches((ItemStack)input, (ItemStack)(comp = new ItemStack(a.func_77973_b(), 1, a.func_77960_j())), (boolean)false)) continue;
            return a;
        }
        return ItemStack.field_190927_a;
    }

    private int getEnchantCount(InventoryCrafting inv) {
        ItemStack k = this.findBaseItem(inv);
        if (!k.func_190926_b()) {
            return EnchantmentHelper.func_82781_a((ItemStack)this.findBaseItem(inv)).size();
        }
        return 0;
    }

    public int getCost(InventoryCrafting inv) {
        MMDMaterial shieldMat = Materials.getMaterialByName(this.materialName);
        MMDMaterial upgradeMat = this.getUpgradeMat(inv);
        float hardDiff = upgradeMat.getStat(MaterialStats.HARDNESS) - shieldMat.getStat(MaterialStats.HARDNESS);
        int enchantCount = this.getEnchantCount(inv);
        float diffVal = hardDiff * 5.0f;
        float enchantVal = upgradeMat.getStat(MaterialStats.MAGICAFFINITY) * (float)enchantCount;
        Float finalVal = Float.valueOf(diffVal + enchantVal);
        if (finalVal.floatValue() < 5.0f) {
            finalVal = Float.valueOf(5.0f);
        }
        return finalVal.intValue();
    }
}

