/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.material;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.MaterialStats;
import com.mcmoddev.lib.data.NameToken;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.material.IFluidBlockGetter;
import com.mcmoddev.lib.material.MMDMaterialType;
import com.mcmoddev.lib.properties.MMDMaterialPropertyBase;
import com.mcmoddev.lib.properties.MaterialProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class MMDMaterial
extends IForgeRegistryEntry.Impl<MMDMaterial> {
    private final Map<NameToken, ItemStack> items = new HashMap<NameToken, ItemStack>();
    private final Map<NameToken, Block> blocks = new HashMap<NameToken, Block>();
    private Fluid fluid;
    private BlockFluidClassic fluidBlock;
    private final Map<MaterialStats, Float> stats = new TreeMap<MaterialStats, Float>();
    private boolean regenerates = false;
    private final boolean isBeaconBase;
    private final boolean hasBlend;
    private final boolean hasOre;
    private final int tintColor;
    private final String identifier;
    private final String titleName;
    private final String enumName;
    private int[] cache = null;
    private final MMDMaterialType materialType;
    private int spawnSize;
    private int defaultDimension;
    private boolean customFluid;
    private IFluidBlockGetter fluidBlockGetter;
    private Map<Names, List<String>> tooltips;

    public MMDMaterial(String name, MMDMaterialType type, float hardness, float strength, float magic, int tintColor, boolean hasOre, boolean hasBlend) {
        this(name, type, hardness, strength, magic, tintColor, hasOre, hasBlend, false);
    }

    public MMDMaterial(String name, MMDMaterialType type, float hardness, float strength, float magic, int tintColor, boolean hasOre, boolean hasBlend, boolean customFluid) {
        this.stats.put(MaterialStats.HARDNESS, Float.valueOf(hardness));
        this.stats.put(MaterialStats.STRENGTH, Float.valueOf(strength));
        this.stats.put(MaterialStats.MAGICAFFINITY, Float.valueOf(magic));
        this.stats.put(MaterialStats.BLASTRESISTANCE, Float.valueOf(2.5f * strength));
        this.stats.put(MaterialStats.BASEDAMAGE, Float.valueOf(this.round(0.25f * hardness, 1)));
        this.tintColor = tintColor;
        this.identifier = name;
        this.titleName = StringUtils.capitalize((String)name);
        this.enumName = (Loader.instance().activeModContainer().getModId() + "_" + name).toUpperCase(Locale.ENGLISH);
        this.isBeaconBase = true;
        this.materialType = type;
        this.hasBlend = hasBlend;
        this.hasOre = hasOre;
        this.spawnSize = 8;
        this.defaultDimension = Integer.MIN_VALUE;
        this.customFluid = customFluid;
        this.fluidBlockGetter = new IFluidBlockGetter(){

            @Override
            public BlockFluidClassic apply(String fluidName) {
                return new BlockFluidClassic(FluidRegistry.getFluid((String)fluidName), Material.field_151587_i);
            }
        };
        this.tooltips = new HashMap<Names, List<String>>();
    }

    public String getName() {
        return this.identifier;
    }

    public String getCapitalizedName() {
        return this.titleName;
    }

    public MMDMaterialType.MaterialType getType() {
        return this.materialType.getMaterialType();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.hashCode() == this.hashCode() && o instanceof MMDMaterial) {
            MMDMaterial other = (MMDMaterial)((Object)o);
            return this.identifier.equals(other.identifier);
        }
        return false;
    }

    public final float getOreSmeltXP() {
        float val = 0.1f * this.stats.get((Object)MaterialStats.MAGICAFFINITY).floatValue();
        return Float.max(0.1f, val);
    }

    public int getToolHarvestLevel() {
        return (int)(this.stats.get((Object)MaterialStats.HARDNESS).floatValue() / 3.0f);
    }

    public String getHarvestTool() {
        switch (this.getType()) {
            case WOOD: {
                return "axe";
            }
        }
        return "pickaxe";
    }

    public int getRequiredHarvestLevel() {
        return (int)MMDMaterial.clamp(0.9f * this.stats.get((Object)MaterialStats.HARDNESS).floatValue() / 3.0f, -1.0f, 3.0f);
    }

    static int clamp(int x, int min, int max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    static float clamp(float x, float min, float max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    static double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public float getBlastResistance() {
        return this.stats.get((Object)MaterialStats.BLASTRESISTANCE).floatValue();
    }

    public float getToolEfficiency() {
        return this.stats.get((Object)MaterialStats.HARDNESS).floatValue();
    }

    public float getOreBlockHardness() {
        return 0.5f * this.stats.get((Object)MaterialStats.HARDNESS).floatValue();
    }

    public float getBlockHardness() {
        return 2.0f * this.stats.get((Object)MaterialStats.HARDNESS).floatValue();
    }

    public int getToolDurability() {
        return (int)(32.0f * this.stats.get((Object)MaterialStats.STRENGTH).floatValue());
    }

    public int getArmorMaxDamageFactor() {
        return (int)(2.0f * this.stats.get((Object)MaterialStats.STRENGTH).floatValue());
    }

    public int getHorseArmorProtection() {
        return (int)((double)this.stats.get((Object)MaterialStats.HARDNESS).floatValue() / 10.0 * 11.0);
    }

    public int[] getDamageReductionArray() {
        if (this.cache == null) {
            float minimum = 5.0f;
            float hardnessFactor = 1.25f;
            float total = 1.25f * this.stats.get((Object)MaterialStats.HARDNESS).floatValue() + 5.0f;
            this.cache = new int[4];
            int feetIndex = EntityEquipmentSlot.FEET.func_188454_b();
            int legsIndex = EntityEquipmentSlot.LEGS.func_188454_b();
            int chestIndex = EntityEquipmentSlot.CHEST.func_188454_b();
            int headIndex = EntityEquipmentSlot.HEAD.func_188454_b();
            this.cache[headIndex] = Math.round(0.1f * total);
            this.cache[chestIndex] = Math.round(0.4f * total);
            this.cache[legsIndex] = Math.round(0.35f * total);
            this.cache[feetIndex] = Math.round(0.15f * total);
        }
        return this.cache;
    }

    public float getBaseAttackDamage() {
        return this.stats.get((Object)MaterialStats.BASEDAMAGE).floatValue();
    }

    private float round(float number, int numDecimalPlaces) {
        int x = 1;
        for (int i = 0; i < numDecimalPlaces; ++i) {
            x *= 10;
        }
        return (float)Math.round(number * (float)x) / (float)x;
    }

    public int getEnchantability() {
        return (int)(2.5f * this.stats.get((Object)MaterialStats.MAGICAFFINITY).floatValue());
    }

    public String getEnumName() {
        return this.enumName;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public MMDMaterial setBlastResistance(float resistance) {
        this.stats.put(MaterialStats.BLASTRESISTANCE, Float.valueOf(resistance));
        return this;
    }

    public MMDMaterial setBaseDamage(float damage) {
        this.stats.put(MaterialStats.BASEDAMAGE, Float.valueOf(damage));
        return this;
    }

    public MMDMaterial addNewItem(Names name, Item item) {
        this.addNewItem(name.toString(), item);
        return this;
    }

    public MMDMaterial addNewItem(@Nonnull String name, @Nonnull Item item) {
        return this.addNewItemFromItemStack(name, new ItemStack(item));
    }

    public MMDMaterial addNewItemFromItemStack(Names name, ItemStack itemStack) {
        this.addNewItemFromItemStack(name.toString(), itemStack);
        return this;
    }

    public MMDMaterial addNewItemFromItemStack(@Nonnull String name, @Nonnull ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            this.items.put(new NameToken(name), itemStack);
        }
        return this;
    }

    public MMDMaterial addNewBlock(Names name, Block block) {
        this.addNewBlock(name.toString(), block);
        return this;
    }

    public MMDMaterial addNewBlock(@Nonnull String name, @Nonnull Block block) {
        NameToken lookup = new NameToken(name);
        if (this.blocks.containsKey(lookup)) {
            MMDLib.logger.warn("Tried adding block {} to a material ({}) that already has it, don't do that!", (Object)name, (Object)this.getCapitalizedName());
            return this;
        }
        this.blocks.put(lookup, block);
        return this;
    }

    public MMDMaterial addNewBlockFromItemStack(Names name, ItemStack itemStack) {
        this.addNewBlockFromItemStack(name.toString(), itemStack);
        return this;
    }

    public MMDMaterial addNewBlockFromItemStack(@Nonnull String name, @Nonnull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (block != Blocks.field_150350_a) {
            this.addNewBlock(name, block);
        }
        return this;
    }

    @Nullable
    public Item getItem(Names name) {
        return this.getItem(name.toString());
    }

    @Nullable
    public Item getItem(String name) {
        NameToken lookup = new NameToken(name);
        return this.getItem(lookup);
    }

    @Nullable
    public Item getItem(NameToken name) {
        if (this.items.containsKey(name)) {
            return this.items.get(name).func_77973_b();
        }
        return null;
    }

    public ItemStack getItemStack(Names name) {
        return this.getItemStack(name.toString(), 1);
    }

    public ItemStack getItemStack(String name) {
        return new ItemStack(this.getItem(name), 1);
    }

    public ItemStack getItemStack(Names name, int amount) {
        return this.getItemStack(name.toString(), amount);
    }

    public ItemStack getItemStack(NameToken name) {
        return this.getItemStack(name, 1);
    }

    public ItemStack getItemStack(NameToken name, int amount) {
        if (!this.hasItem(name.asString()) || this.items.get(name) == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack base = this.items.get(name);
        if (base.func_77981_g()) {
            return new ItemStack(base.func_77973_b(), amount, base.func_77960_j());
        }
        return new ItemStack(base.func_77973_b(), amount);
    }

    public ItemStack getItemStack(String name, int amount) {
        NameToken lookup = new NameToken(name);
        return this.getItemStack(lookup, amount);
    }

    @Nullable
    public Block getBlock(Names name) {
        return this.getBlock(name.toString());
    }

    @Nullable
    public Block getBlock(String name) {
        NameToken lookup = new NameToken(name);
        return this.getBlock(lookup);
    }

    @Nullable
    public Block getBlock(NameToken name) {
        if (this.blocks.containsKey(name)) {
            return this.blocks.get(name);
        }
        return null;
    }

    public ItemStack getBlockItemStack(Names name) {
        return this.getBlockItemStack(name.toString(), 1);
    }

    public ItemStack getBlockItemStack(String name) {
        return this.getBlockItemStack(name, 1);
    }

    public ItemStack getBlockItemStack(NameToken name) {
        return this.getBlockItemStack(name, 1);
    }

    public ItemStack getBlockItemStack(Names name, int amount) {
        return this.getBlockItemStack(name.toString(), amount);
    }

    public ItemStack getBlockItemStack(String name, int amount) {
        return this.getBlockItemStack(new NameToken(name), amount);
    }

    public ItemStack getBlockItemStack(NameToken name, int amount) {
        return new ItemStack(this.getBlock(name), amount);
    }

    public Map<NameToken, Block> getBlockRegistry() {
        return ImmutableMap.copyOf(this.blocks);
    }

    public ImmutableList<Block> getBlocks() {
        return ImmutableList.copyOf(this.blocks.values());
    }

    public ImmutableList<ItemStack> getItems() {
        return ImmutableList.copyOf(this.items.values());
    }

    public boolean hasOre() {
        return this.hasOre;
    }

    public boolean hasBlend() {
        return this.hasBlend;
    }

    public boolean isRare() {
        return this.materialType.hasRare();
    }

    public boolean isVanilla() {
        return this.materialType.hasVanilla();
    }

    public boolean isAlloy() {
        return this.materialType.hasAlloy();
    }

    public boolean isOreless() {
        return this.materialType.hasOreless();
    }

    public boolean isSpecial() {
        return this.materialType.hasSpecial();
    }

    public boolean regenerates() {
        return this.regenerates;
    }

    public boolean isBeaconBase() {
        return this.isBeaconBase;
    }

    public boolean hasItem(Names name) {
        return this.hasItem(name.toString());
    }

    public boolean hasItem(String name) {
        NameToken lookup = new NameToken(name);
        return this.items.containsKey(lookup);
    }

    public boolean hasBlock(String name) {
        NameToken lookup = new NameToken(name);
        return this.blocks.containsKey(lookup);
    }

    public boolean hasBlock(Names name) {
        return this.hasBlock(name.toString());
    }

    public float getStat(MaterialStats name) {
        if (this.stats.containsKey((Object)name)) {
            return this.stats.get((Object)name).floatValue();
        }
        return 0.0f;
    }

    public void setStat(MaterialStats name, float value) {
        this.stats.put(name, Float.valueOf(value));
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public BlockFluidClassic getFluidBlock() {
        return this.fluidBlock;
    }

    public void setFluidBlock(BlockFluidClassic fluidBlock) {
        this.fluidBlock = fluidBlock;
    }

    public void setRegenerates(boolean regen) {
        this.regenerates = regen;
    }

    public final Material getVanillaMaterial() {
        return this.materialType.getVanillaType();
    }

    public final SoundType getSoundType() {
        switch (this.getType()) {
            case METAL: {
                return SoundType.field_185852_e;
            }
            case GEM: {
                return SoundType.field_185853_f;
            }
            case ROCK: {
                return SoundType.field_185851_d;
            }
            case MINERAL: {
                return SoundType.field_185855_h;
            }
            case WOOD: {
                return SoundType.field_185848_a;
            }
        }
        return SoundType.field_185849_b;
    }

    public int getSpawnSize() {
        return this.spawnSize;
    }

    public MMDMaterial setSpawnSize(int size) {
        this.spawnSize = size;
        return this;
    }

    public int getDefaultDimension() {
        return this.defaultDimension;
    }

    public MMDMaterial setDefaultDimension(int dim) {
        this.defaultDimension = dim;
        return this;
    }

    public boolean isEmpty() {
        return "empty".equals(this.getName());
    }

    public boolean isDefault() {
        return "default".equalsIgnoreCase(this.getName());
    }

    public Map<NameToken, ItemStack> getItemRegistry() {
        return ImmutableMap.copyOf(this.items);
    }

    public boolean hasCustomFluid() {
        return this.customFluid;
    }

    public BlockFluidClassic getCustomFluid() {
        return this.fluidBlockGetter.apply(this.getName());
    }

    public void setFluidBlockGetter(IFluidBlockGetter fluidBlockGetter) {
        this.fluidBlockGetter = fluidBlockGetter;
    }

    private MMDMaterialPropertyBase findEffect(ItemStack stack, EntityPlayer p) {
        Optional<MMDMaterialPropertyBase> pr = MaterialProperties.get().getEntries().stream().map(ent -> (MMDMaterialPropertyBase)ent.getValue()).filter(prop -> prop.hasEffect(stack, p)).findFirst();
        return pr.orElseGet(null);
    }

    private MMDMaterialPropertyBase findEffect(ItemStack stack, EntityLivingBase b) {
        Optional<MMDMaterialPropertyBase> pr = MaterialProperties.get().getEntries().stream().map(ent -> (MMDMaterialPropertyBase)ent.getValue()).filter(prop -> prop.hasEffect(stack, b)).findFirst();
        return pr.orElseGet(null);
    }

    public boolean hasEffect(ItemStack itemStack, EntityPlayer player) {
        return MaterialProperties.get().getEntries().stream().anyMatch(prop -> ((MMDMaterialPropertyBase)prop.getValue()).hasEffect(itemStack, player));
    }

    public boolean hasEffect(ItemStack itemStack, EntityLivingBase ent) {
        return MaterialProperties.get().getEntries().stream().anyMatch(prop -> ((MMDMaterialPropertyBase)prop.getValue()).hasEffect(itemStack, ent));
    }

    public void applyEffect(ItemStack itemStack, EntityPlayer player) {
        MMDMaterialPropertyBase pr = this.findEffect(itemStack, player);
        if (pr != null) {
            pr.apply(itemStack, player);
        }
    }

    public void applyEffect(ItemStack itemStack, EntityLivingBase ent) {
        MMDMaterialPropertyBase pr = this.findEffect(itemStack, ent);
        if (pr != null) {
            pr.apply(itemStack, ent);
        }
    }

    public List<String> getTooltipFor(Names name) {
        return this.tooltips.getOrDefault((Object)name, Collections.emptyList());
    }

    public void addTooltipFor(Names name, List<String> data) {
        this.tooltips.put(name, data);
    }
}

