/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.item.MMDItemHelper;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.Logger;

public class ItemMMDSickle
extends ItemTool
implements IMMDObject {
    private static final ImmutableSet<Material> vanilla_materials = ImmutableSet.of((Object)Material.field_151569_G, (Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151572_C, (Object)Material.field_151570_A, (Object[])new Material[0]);
    private final MMDMaterial material;
    private final int actionDiameter;
    @Nullable
    private String toolClass;

    public ItemMMDSickle(MMDMaterial material) {
        super(Materials.getToolMaterialFor(material), null);
        this.field_77864_a = material.getToolEfficiency();
        this.func_77656_e(material.getToolDurability());
        this.material = material;
        this.actionDiameter = 3;
    }

    @Override
    public MMDMaterial getMMDMaterial() {
        return this.material;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return this.field_77864_a;
        }
        return this.isEffective(state) ? this.field_77864_a : 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        this.getEffectedBlocks(pos, player.func_130014_f_(), stack, this.actionDiameter).stream().filter(entityPos -> this.isEffective(player.func_130014_f_().func_180495_p(entityPos))).forEach(entityPos -> this.breakBlock(stack, player.func_130014_f_(), player, pos, (BlockPos)entityPos));
        return true;
    }

    private static void sendPacket(Entity player, Packet<?> packet) {
        if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71135_a != null) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a(packet);
        }
    }

    private void breakBlock(ItemStack tool, World world, EntityPlayer player, BlockPos centralPosition, BlockPos actualPosition) {
        if (world.func_175623_d(actualPosition)) {
            return;
        }
        IBlockState bsatapos = world.func_180495_p(actualPosition);
        Block block = bsatapos.func_177230_c();
        tool.func_179548_a(world, bsatapos, centralPosition, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)actualPosition);
            if (xp == -1) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(actualPosition);
            if (block.removedByPlayer(bsatapos, world, actualPosition, player, true)) {
                block.func_176206_d(world, actualPosition, bsatapos);
                block.func_180657_a(world, player, actualPosition, bsatapos, tileEntity, tool);
                block.func_180637_b(world, actualPosition, xp);
            }
            ItemMMDSickle.sendPacket((Entity)player, new SPacketBlockChange(world, actualPosition));
        } else {
            world.func_175669_a(2001, actualPosition, Block.func_176210_f((IBlockState)bsatapos));
            if (block.removedByPlayer(bsatapos, world, actualPosition, player, true)) {
                block.func_176206_d(world, actualPosition, bsatapos);
            }
            tool.func_179548_a(world, bsatapos, actualPosition, player);
            if (tool.func_190916_E() == 0 && tool.equals(player.func_184614_ca())) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)tool, (EnumHand)EnumHand.MAIN_HAND);
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            NetHandlerPlayClient netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, actualPosition, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    private static boolean isToolEffective(ItemStack stack, IBlockState state) {
        List<Boolean> isEffective = stack.func_77973_b().getToolClasses(stack).stream().map(type -> state.func_177230_c().isToolEffective(type, state)).collect(Collectors.toList());
        stack.func_77973_b().getToolClasses(stack).forEach(arg_0 -> ((Logger)MMDLib.logger).fatal(arg_0));
        isEffective.forEach(b -> MMDLib.logger.debug("%s", b));
        return isEffective.contains(true);
    }

    private ImmutableList<BlockPos> getEffectedBlocks(BlockPos pos, World world, ItemStack stack, int range) {
        MMDLib.logger.debug("Entered getEffectedBlocks");
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemMMDSickle)) {
            MMDLib.logger.debug("Early out because tool-stack is empty");
            return ImmutableList.of();
        }
        int rangeOff = (range - 1) / 2;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int x = -rangeOff; x < rangeOff + 1; ++x) {
            for (int z = -rangeOff; z < rangeOff + 1; ++z) {
                BlockPos potential = pos.func_177982_a(x, 0, z);
                if (!this.isEffective(world.func_180495_p(potential))) continue;
                builder.add((Object)potential);
            }
        }
        return builder.build();
    }

    private boolean isEffective(IBlockState state) {
        return vanilla_materials.contains((Object)state.func_185904_a());
    }

    @Deprecated
    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            boolean attackDamageReturned = multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.field_77865_bY, 0));
            boolean bl = multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
        }
        return multimap;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        int level = super.getHarvestLevel(stack, toolClass, player, blockState);
        if (level == -1 && toolClass.equals(this.toolClass)) {
            return this.material.getToolHarvestLevel();
        }
        return level;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolClass != null ? ImmutableSet.of((Object)this.toolClass) : super.getToolClasses(stack);
    }

    public boolean func_82789_a(ItemStack intputItem, ItemStack repairMaterial) {
        return MMDItemHelper.isToolRepairable(repairMaterial, this.material.getCapitalizedName());
    }

    public void func_77663_a(ItemStack item, World world, Entity player, int inventoryIndex, boolean isHeld) {
        MMDItemHelper.doRegeneration(item, world, isHeld, this.material.regenerates());
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(item, target, attacker);
        if (this.getMMDMaterial().hasEffect(item, target)) {
            this.getMMDMaterial().applyEffect(item, target);
        }
        return true;
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        if (this.getMMDMaterial().hasEffect(item, crafter)) {
            this.getMMDMaterial().applyEffect(item, crafter);
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        List<String> tt = this.getMMDMaterial().getTooltipFor(Names.SCYTHE);
        if (!tt.isEmpty()) {
            tooltip.addAll(tt);
        }
    }
}

