/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.inventory;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTankHandler
implements IFluidHandler {
    private final IFluidTank tank;
    private final FluidTankPropertiesWrapper properties = new FluidTankPropertiesWrapper();

    public FluidTankHandler(IFluidTank tank) {
        this.tank = tank;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.properties};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack existing;
        if (resource != null && (existing = this.tank.getFluid()) != null && existing.isFluidEqual(resource)) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    private class FluidTankPropertiesWrapper
    implements IFluidTankProperties {
        FluidTankPropertiesWrapper() {
        }

        @Nullable
        public FluidStack getContents() {
            FluidStack contents = FluidTankHandler.this.tank.getFluid();
            return contents == null ? null : contents.copy();
        }

        public int getCapacity() {
            return FluidTankHandler.this.tank.getCapacity();
        }

        public boolean canFill() {
            IFluidTank tank = FluidTankHandler.this.tank;
            return !(tank instanceof FluidTank) || ((FluidTank)tank).canFill();
        }

        public boolean canDrain() {
            IFluidTank tank = FluidTankHandler.this.tank;
            return !(tank instanceof FluidTank) || ((FluidTank)tank).canDrain();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            IFluidTank tank = FluidTankHandler.this.tank;
            return !(tank instanceof FluidTank) || ((FluidTank)tank).canFillFluidType(fluidStack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            IFluidTank tank = FluidTankHandler.this.tank;
            return !(tank instanceof FluidTank) || ((FluidTank)tank).canDrainFluidType(fluidStack);
        }
    }
}

