/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins.tinkers;

import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mcmoddev.lib.data.MaterialStats;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.integration.plugins.tinkers.TinkerTraitLocation;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class TinkersMaterial
extends IForgeRegistryEntry.Impl<TinkersMaterial>
implements IMMDObject {
    private Map<String, Number> rawStats;
    private List<Pair<String, TinkerTraitLocation>> traits;
    private List<ItemStack> items;
    private List<FluidStack> recipe = Lists.newCopyOnWriteArrayList();
    private Set<Pair<ItemStack, Integer>> extraMeltings;
    private ItemStack representativeItem;
    private Material ticonMat = Material.UNKNOWN;
    private MMDMaterial baseMaterial;
    private FluidStack recipeOutput;
    private boolean toolForge;
    private boolean castable = true;
    private boolean craftable = false;

    public TinkersMaterial(MMDMaterial base) {
        this.baseMaterial = base;
        this.rawStats = Maps.newConcurrentMap();
        this.traits = Lists.newCopyOnWriteArrayList();
        this.items = Lists.newCopyOnWriteArrayList();
        this.extraMeltings = Sets.newLinkedHashSet();
        this.representativeItem = base.getItemStack(Names.INGOT);
        this.setRegistryName(this.baseMaterial.getRegistryName());
    }

    public TinkersMaterial addStat(String statName, Number statValue) {
        this.rawStats.put(statName, statValue);
        return this;
    }

    public TinkersMaterial addTrait(String trait) {
        this.traits.add((Pair<String, TinkerTraitLocation>)Pair.of((Object)trait, (Object)((Object)TinkerTraitLocation.GENERAL)));
        return this;
    }

    public TinkersMaterial addTrait(String trait, TinkerTraitLocation location) {
        this.traits.add((Pair<String, TinkerTraitLocation>)Pair.of((Object)trait, (Object)((Object)location)));
        return this;
    }

    public TinkersMaterial setRepresentativeItem(Item item) {
        return this.setRepresentativeItem(new ItemStack(item));
    }

    public TinkersMaterial setRepresentativeItem(Block block) {
        return this.setRepresentativeItem(Item.func_150898_a((Block)block));
    }

    public TinkersMaterial setRepresentativeItem(ItemStack itemStack) {
        this.representativeItem = itemStack.func_77946_l();
        return this;
    }

    public TinkersMaterial addItem(Item item) {
        return this.addItem(new ItemStack(item));
    }

    public TinkersMaterial addItem(Block block) {
        return this.addItem(Item.func_150898_a((Block)block));
    }

    public TinkersMaterial addItem(ItemStack itemStack) {
        this.items.add(itemStack.func_77946_l());
        return this;
    }

    public TinkersMaterial addAlloyRecipe(int outputAmount, FluidStack ... recipe) {
        this.recipeOutput = FluidRegistry.getFluidStack((String)this.getMMDMaterial().getName(), (int)outputAmount);
        this.recipe.addAll(Arrays.asList(recipe).stream().map(obj -> obj).collect(Collectors.toList()));
        return this;
    }

    public TinkersMaterial addAlloyRecipe(int outputAmount, Object ... recipe) {
        this.recipeOutput = FluidRegistry.getFluidStack((String)this.getMMDMaterial().getName(), (int)outputAmount);
        for (int i = 0; i < recipe.length; i += 2) {
            this.recipe.add(FluidRegistry.getFluidStack((String)((String)recipe[i]), (int)((Integer)recipe[i + 1])));
        }
        return this;
    }

    public ArrowShaftMaterialStats getArrowShaftStats() {
        float modifier = this.rawStats.getOrDefault("shaftModifier", Float.valueOf(1.0f)).floatValue();
        int bonus = this.rawStats.getOrDefault("shaftBonusAmmo", 1).intValue();
        return new ArrowShaftMaterialStats(modifier, bonus);
    }

    private static Float calcDrawSpeed(int durability) {
        float val;
        if (durability < 204) {
            val = 1.0f;
        } else {
            val = (float)(durability - 200 + 1) / 10.0f;
            val = (float)((double)val - Math.floor(val));
        }
        return Float.valueOf(val);
    }

    public BowMaterialStats getBowStats() {
        float speed = this.rawStats.getOrDefault("bowDrawSpeed", TinkersMaterial.calcDrawSpeed(this.baseMaterial.getToolDurability())).floatValue();
        float damage = this.rawStats.getOrDefault("bowDamage", Float.valueOf(this.baseMaterial.getBaseAttackDamage() + 3.0f)).floatValue();
        float range = this.rawStats.getOrDefault("bowRange", Float.valueOf(15.0f)).floatValue();
        return new BowMaterialStats(speed, range, damage);
    }

    public BowStringMaterialStats getBowStringStats() {
        float modifier = this.rawStats.getOrDefault("bowstringModifier", Float.valueOf(1.0f)).floatValue();
        return new BowStringMaterialStats(modifier);
    }

    public ExtraMaterialStats getExtraStats() {
        int durability = this.rawStats.getOrDefault("extraDurability", this.baseMaterial.getToolDurability() / 10).intValue();
        return new ExtraMaterialStats(durability);
    }

    public FletchingMaterialStats getFletchingStats() {
        float accuracy = this.rawStats.getOrDefault("fletchingAccuracy", Float.valueOf(1.0f)).floatValue();
        float modifier = this.rawStats.getOrDefault("fletchingModifier", Float.valueOf(1.0f)).floatValue();
        return new FletchingMaterialStats(accuracy, modifier);
    }

    public HandleMaterialStats getHandleStats() {
        int durability = this.rawStats.getOrDefault("bodyDurability", this.baseMaterial.getToolDurability() / 7).intValue();
        float modifier = this.rawStats.getOrDefault("bodyModifier", Float.valueOf(this.baseMaterial.getStat(MaterialStats.MAGICAFFINITY) * 2.0f / 9.0f)).floatValue();
        return new HandleMaterialStats(modifier, durability);
    }

    public HeadMaterialStats getHeadStats() {
        int durability = this.rawStats.getOrDefault("headDurability", this.baseMaterial.getToolDurability()).intValue();
        float speed = this.rawStats.getOrDefault("miningSpeed", Float.valueOf(this.baseMaterial.getStat(MaterialStats.HARDNESS) * 0.85f)).floatValue();
        float damage = this.rawStats.getOrDefault("headAttackDamage", Float.valueOf(this.baseMaterial.getBaseAttackDamage() * 2.0f)).floatValue();
        int miningLevel = this.rawStats.getOrDefault("miningLevel", this.baseMaterial.getToolHarvestLevel()).intValue();
        return new HeadMaterialStats(durability, speed, damage, miningLevel);
    }

    public CoreMaterialStats getCoreStats() {
        float minimum = 5.0f;
        float hardnessFactor = 1.25f;
        int durability = (int)(2.0f * (float)this.baseMaterial.getArmorMaxDamageFactor());
        float defense = 1.25f * (float)this.baseMaterial.getDamageReductionArray()[EntityEquipmentSlot.CHEST.func_188454_b()] + 5.0f;
        return new CoreMaterialStats((float)durability, defense);
    }

    public PlatesMaterialStats getPlatesStats() {
        float modifier = this.baseMaterial.getStat(MaterialStats.MAGICAFFINITY) * 2.0f / 9.0f;
        int durability = this.baseMaterial.getToolDurability() / 7;
        float toughness = this.baseMaterial.getStat(MaterialStats.HARDNESS) > 10.0f ? (float)((int)(this.baseMaterial.getStat(MaterialStats.HARDNESS) / 5.0f)) : 0.0f;
        return new PlatesMaterialStats(modifier, (float)durability, toughness);
    }

    public TrimMaterialStats getTrimStats() {
        int durability = this.baseMaterial.getToolDurability() / 10;
        return new TrimMaterialStats((float)durability);
    }

    public TinkersMaterial setToolForge(boolean toolForge) {
        this.toolForge = toolForge;
        return this;
    }

    public boolean getToolForge() {
        return this.toolForge;
    }

    public TinkersMaterial setCastable(boolean castable) {
        this.castable = castable;
        return this;
    }

    public TinkersMaterial setCraftable(boolean craftable) {
        this.craftable = craftable;
        return this;
    }

    public boolean getCastable() {
        return this.castable;
    }

    public boolean getCraftable() {
        return this.craftable;
    }

    public ItemStack getRepresentativeItem() {
        return this.representativeItem.func_77946_l();
    }

    public TinkersMaterial create() {
        if (this.ticonMat != Material.UNKNOWN) {
            return this;
        }
        this.ticonMat = new Material(this.baseMaterial.getName(), this.baseMaterial.getTintColor());
        return this;
    }

    public TinkersMaterial addExtraMelting(Item item, int amount) {
        return this.addExtraMelting(new ItemStack(item), amount);
    }

    public TinkersMaterial addExtraMelting(Block block, int amount) {
        return this.addExtraMelting(Item.func_150898_a((Block)block), amount);
    }

    public TinkersMaterial addExtraMelting(ItemStack itemStack, int amount) {
        this.extraMeltings.add((Pair<ItemStack, Integer>)Pair.of((Object)itemStack.func_77946_l(), (Object)amount));
        return this;
    }

    public TinkersMaterial addExtraMelting(String name, int amount) {
        return this.addExtraMelting(this.baseMaterial.getItemStack(name), amount);
    }

    public List<FluidStack> getAlloyRecipe() {
        LinkedList<FluidStack> rv = new LinkedList<FluidStack>();
        rv.add(this.recipeOutput);
        rv.addAll(this.recipe);
        return rv;
    }

    public String getName() {
        return this.baseMaterial.getName();
    }

    public Material getTinkerMaterial() {
        if (this.ticonMat == Material.UNKNOWN) {
            return this.create().getTinkerMaterial();
        }
        return this.ticonMat;
    }

    public boolean hasTraits() {
        return !this.traits.isEmpty();
    }

    public boolean hasAlloyRecipe() {
        return !this.recipe.isEmpty();
    }

    public List<Pair<String, TinkerTraitLocation>> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @Override
    public MMDMaterial getMMDMaterial() {
        return this.baseMaterial;
    }
}

