/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.jei;

import com.mcmoddev.lib.integration.jei.ICrusherRecipeWrapper;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public class ICrusherRecipeCategory
implements IRecipeCategory<ICrusherRecipeWrapper> {
    private final ResourceLocation resourceLocation = new ResourceLocation("mmdlib", "textures/jei/jeihammeroverlay.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated hammer;

    public ICrusherRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(this.resourceLocation, 0, 0, 166, 130);
        this.icon = guiHelper.createDrawable(this.resourceLocation, 170, 2, 16, 16);
        IDrawableStatic hammerDrawable = guiHelper.createDrawable(this.resourceLocation, 169, 17, 32, 32);
        this.hammer = guiHelper.createAnimatedDrawable(hammerDrawable, 100, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public String getUid() {
        return "mmdlib.crackhammer";
    }

    public String getModName() {
        return "mmdlib";
    }

    public String getTitle() {
        return new TextComponentTranslation(String.format(this.getUid(), new Object[0]), new Object[0]).func_150254_d();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull ICrusherRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 42, 14);
        guiItemStacks.init(1, false, 119, 14);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)outputs.get(0));
    }

    public void drawExtras(Minecraft minecraft) {
        this.hammer.draw(minecraft, 71, 6);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }
}

