/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.init;

import com.mcmoddev.lib.data.MaterialStats;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.VillagerTradeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.Loader;

public abstract class VillagerTrades {
    protected static final int ARMOR_SMITH = 196864;
    protected static final int WEAPON_SMITH = 197120;
    protected static final int TOOL_SMITH = 197376;
    protected static final ResourceLocation SMITH_RL = new ResourceLocation("minecraft:smith");
    protected static final int ARMOR_SMITH_ID = 1;
    protected static final int WEAPON_SMITH_ID = 2;
    protected static final int TOOL_SMITH_ID = 3;
    protected static final int TRADES_PER_LEVEL = 4;

    protected VillagerTrades() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
        VillagerTrades.registerCommonTrades();
    }

    private static EntityVillager.ITradeList[] getTrades(Names name, MMDMaterial material, int price, int priceMod) {
        return VillagerTrades.makeTradePalette(new EntityVillager.ITradeList[][]{VillagerTrades.makePurchasePalette(price + priceMod, material.getItemStack(name))});
    }

    protected static void registerCommonTrades() {
        String modid = Loader.instance().activeModContainer().getModId();
        HashMap<Integer, List<EntityVillager.ITradeList>> tradesTable = new HashMap<Integer, List<EntityVillager.ITradeList>>();
        Materials.getMaterialsByMod(modid).stream().filter(material -> !material.isEmpty()).filter(material -> !material.isRare()).filter(material -> {
            float val = material.getStat(MaterialStats.HARDNESS) + material.getStat(MaterialStats.STRENGTH) + material.getStat(MaterialStats.MAGICAFFINITY) + (float)material.getToolHarvestLevel();
            return VillagerTrades.emeraldPurchaseValue(val) < 65 && VillagerTrades.emeraldSaleValue(val) < 65;
        }).forEach(material -> {
            VillagerTrades.makeArmorTrades(material);
            VillagerTrades.makeToolTrades(material);
            VillagerTrades.makeWeaponTrades(material);
            VillagerTrades.makeIngotTrades(material);
            if (material.getStat(MaterialStats.MAGICAFFINITY) > 5.0f) {
                float val = material.getStat(MaterialStats.HARDNESS) + material.getStat(MaterialStats.STRENGTH) + material.getStat(MaterialStats.MAGICAFFINITY) + (float)material.getToolHarvestLevel();
                int tradeLevel = VillagerTrades.tradeLevel(val);
                int armorSmithKey = 0x30100 | tradeLevel + 1;
                int weaponSmithKey = 0x30200 | tradeLevel + 1;
                int toolSmithKeyOne = 0x30300 | tradeLevel + 1;
                int toolSmithKeyTwo = 0x30300 | tradeLevel + 2;
                int armorMod = (int)(material.getStat(MaterialStats.HARDNESS) / 2.0f);
                int weaponMod = (int)(material.getBaseAttackDamage() / 2.0f);
                int emeraldPurchaseValueBase = VillagerTrades.emeraldPurchaseValue(val);
                Arrays.asList(Names.SWORD, Names.CROSSBOW, Names.BOW).stream().filter(material::hasItem).forEach(name -> tradesTable.computeIfAbsent(weaponSmithKey, key -> new ArrayList()).addAll(Collections.singletonList(new EntityVillager.ListEnchantedItemForEmeralds(material.getItem((Names)((Object)((Object)name))), new EntityVillager.PriceInfo(emeraldPurchaseValueBase + 7 + weaponMod - 1, emeraldPurchaseValueBase + 12 + weaponMod - 1)))));
                Arrays.asList(Names.HELMET, Names.CHESTPLATE, Names.LEGGINGS, Names.BOOTS).stream().filter(material::hasItem).forEach(name -> tradesTable.computeIfAbsent(armorSmithKey, key -> new ArrayList()).addAll(Collections.singletonList(new EntityVillager.ListEnchantedItemForEmeralds(material.getItem((Names)((Object)((Object)name))), new EntityVillager.PriceInfo(emeraldPurchaseValueBase + 7 + armorMod, emeraldPurchaseValueBase + 12 + armorMod)))));
                Arrays.asList(Names.AXE, Names.HOE, Names.SHOVEL, Names.PICKAXE).stream().filter(material::hasItem).forEach(name -> tradesTable.computeIfAbsent(toolSmithKeyOne, key -> new ArrayList()).addAll(Collections.singletonList(new EntityVillager.ListEnchantedItemForEmeralds(material.getItem((Names)((Object)((Object)name))), new EntityVillager.PriceInfo(emeraldPurchaseValueBase + 7, emeraldPurchaseValueBase + 12)))));
                tradesTable.computeIfAbsent(toolSmithKeyTwo, key -> new ArrayList()).addAll(Collections.singletonList(new EntityVillager.ListEnchantedItemForEmeralds(material.getItem(Names.CRACKHAMMER), new EntityVillager.PriceInfo(emeraldPurchaseValueBase + 7, emeraldPurchaseValueBase + 12))));
            }
        });
        VillagerTrades.commitTrades(tradesTable);
    }

    private static void makeIngotTrades(MMDMaterial material) {
        ItemStack itemStack;
        if (material.hasItem(Names.INGOT) && !(itemStack = material.getItemStack(Names.INGOT, 12)).func_77973_b().equals(Items.field_151166_bC) && !itemStack.func_77973_b().equals(Items.field_151045_i)) {
            float val = material.getStat(MaterialStats.HARDNESS) + material.getStat(MaterialStats.STRENGTH) + material.getStat(MaterialStats.MAGICAFFINITY) + (float)material.getToolHarvestLevel();
            VillagerTrades.insertTrades(Names.INGOT, material, VillagerTrades.emeraldPurchaseValue(val), VillagerTrades.tradeLevel(val), SMITH_RL, 1);
            VillagerTrades.insertTrades(Names.INGOT, material, VillagerTrades.emeraldPurchaseValue(val), VillagerTrades.tradeLevel(val), SMITH_RL, 2);
            VillagerTrades.insertTrades(Names.INGOT, material, VillagerTrades.emeraldPurchaseValue(val), VillagerTrades.tradeLevel(val), SMITH_RL, 3);
        }
    }

    private static void makeWeaponTrades(MMDMaterial material) {
        VillagerTrades.makeTrades(new Names[]{Names.SWORD, Names.CROSSBOW, Names.BOW}, material, 2);
    }

    private static void makeToolTrades(MMDMaterial material) {
        VillagerTrades.makeTrades(new Names[]{Names.AXE, Names.HOE, Names.SHOVEL, Names.CRACKHAMMER, Names.PICKAXE}, material, 3);
    }

    private static void makeArmorTrades(MMDMaterial material) {
        VillagerTrades.makeTrades(new Names[]{Names.HELMET, Names.CHESTPLATE, Names.LEGGINGS, Names.BOOTS}, material, 1);
    }

    private static void makeTrades(Names[] names, MMDMaterial material, int smithId) {
        float val = material.getStat(MaterialStats.HARDNESS) + material.getStat(MaterialStats.STRENGTH) + material.getStat(MaterialStats.MAGICAFFINITY) + (float)material.getToolHarvestLevel();
        Arrays.asList(names).stream().filter(name -> !material.hasItem((Names)((Object)name))).forEach(name -> VillagerTrades.insertTrades(name, material, VillagerTrades.emeraldPurchaseValue(val), VillagerTrades.tradeLevel(val), SMITH_RL, smithId));
    }

    private static int getPriceMod(Names name, MMDMaterial material) {
        switch (name) {
            case HELMET: 
            case CHESTPLATE: 
            case LEGGINGS: 
            case BOOTS: {
                return (int)(material.getStat(MaterialStats.HARDNESS) / 2.0f);
            }
            case SWORD: {
                return (int)(material.getBaseAttackDamage() / 2.0f) - 1;
            }
        }
        return 0;
    }

    private static void insertTrades(Names name, MMDMaterial material, int emeraldPurch, int tradeLevel, ResourceLocation smithRl, int smithId) {
        EntityVillager.ITradeList[] armorTrades = VillagerTrades.getTrades(name, material, emeraldPurch, VillagerTrades.getPriceMod(name, material));
        VillagerTradeHelper.insertTrades(smithRl, smithId, tradeLevel, armorTrades);
    }

    protected static void registerModSpecificTrades() {
    }

    protected static void commitTrades(@Nonnull Map<Integer, List<EntityVillager.ITradeList>> tradesTable) {
        for (Map.Entry<Integer, List<EntityVillager.ITradeList>> ent : tradesTable.entrySet()) {
            int k = ent.getKey();
            List<EntityVillager.ITradeList> trades = ent.getValue();
            int profession = k >> 16 & 0xFF;
            int career = k >> 8 & 0xFF;
            int level = k & 0xFF;
            VillagerTradeHelper.insertTrades(profession, career, level, new MultiTradeGenerator(4, trades));
        }
    }

    protected static int emeraldPurchaseValue(@Nonnull float value) {
        return Math.max(1, (int)(value * 0.2f));
    }

    protected static int emeraldSaleValue(@Nonnull float value) {
        return Math.max(1, VillagerTrades.emeraldPurchaseValue(value) / 3);
    }

    protected static int tradeLevel(@Nonnull float value) {
        return Math.max(1, Math.min(4, (int)(value * 0.1f)));
    }

    protected static int fluctuation(@Nonnull int baseValue) {
        if (baseValue <= 1) {
            return 0;
        }
        return Math.max(2, baseValue / 4);
    }

    protected static EntityVillager.ITradeList[] makePurchasePalette(@Nonnull int emeraldPrice, @Nonnull int stackSize, Item ... items) {
        ItemStack[] itemStacks = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            itemStacks[i] = new ItemStack(items[i], stackSize);
        }
        return VillagerTrades.makePurchasePalette(emeraldPrice, itemStacks);
    }

    protected static EntityVillager.ITradeList[] makePurchasePalette(@Nonnull int emeraldPrice, ItemStack ... itemStacks) {
        EntityVillager.ITradeList[] trades = new EntityVillager.ITradeList[itemStacks.length];
        for (int i = 0; i < itemStacks.length; ++i) {
            trades[i] = new SimpleTrade(new ItemStack(Items.field_151166_bC, emeraldPrice, 0), VillagerTrades.fluctuation(emeraldPrice), itemStacks[i], 0);
        }
        return trades;
    }

    protected static EntityVillager.ITradeList[] makeSalePalette(@Nonnull int emeraldValue, @Nonnull int stackSize, Item ... items) {
        ItemStack[] itemStacks = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            itemStacks[i] = new ItemStack(items[i], stackSize);
        }
        return VillagerTrades.makeSalePalette(emeraldValue, itemStacks);
    }

    protected static EntityVillager.ITradeList[] makeSalePalette(@Nonnull int emeraldValue, ItemStack ... itemStacks) {
        EntityVillager.ITradeList[] trades = new EntityVillager.ITradeList[itemStacks.length];
        for (int i = 0; i < itemStacks.length; ++i) {
            trades[i] = new SimpleTrade(itemStacks[i], VillagerTrades.fluctuation(itemStacks[i].func_190916_E()), new ItemStack(Items.field_151166_bC, emeraldValue, 0), 0);
        }
        return trades;
    }

    protected static EntityVillager.ITradeList[] makeTradePalette(EntityVillager.ITradeList[] ... list) {
        if (list.length == 1) {
            return list[0];
        }
        int totalsize = 0;
        for (EntityVillager.ITradeList[] e : list) {
            totalsize += e.length;
        }
        EntityVillager.ITradeList[] concat = new EntityVillager.ITradeList[totalsize];
        int index = 0;
        int element = 0;
        while (index < totalsize) {
            System.arraycopy(list[element], 0, concat, index, list[element].length);
            index += list[element].length;
            ++element;
        }
        return concat;
    }

    public static class SimpleTrade
    implements EntityVillager.ITradeList {
        private final ItemStack input1;
        private final int maxInputMarkup1;
        private final ItemStack input2;
        private final int maxInputMarkup2;
        private final ItemStack output;
        private final int maxOutputMarkup;
        private final int maxTrades;
        private final int maxTradeVariation;

        public SimpleTrade(@Nonnull ItemStack in1, @Nonnull int variation1, ItemStack in2, @Nonnull int variation2, @Nonnull ItemStack out, @Nonnull int variationOut, @Nonnull int numberTrades, @Nonnull int tradeNumberVariation) {
            this.input1 = in1;
            this.maxInputMarkup1 = variation1;
            this.input2 = in2;
            this.maxInputMarkup2 = variation2;
            this.output = out;
            this.maxOutputMarkup = variationOut;
            this.maxTrades = numberTrades;
            this.maxTradeVariation = tradeNumberVariation;
        }

        public SimpleTrade(@Nonnull ItemStack in1, @Nonnull int v1, ItemStack in2, @Nonnull int v2, @Nonnull ItemStack out, @Nonnull int vout) {
            this(in1, v1, in2, v2, out, vout, -1, -1);
        }

        public SimpleTrade(@Nonnull ItemStack in1, @Nonnull int v1, @Nonnull ItemStack out, @Nonnull int vout) {
            this(in1, v1, ItemStack.field_190927_a, 0, out, vout, -1, -1);
        }

        public SimpleTrade(@Nonnull ItemStack in1, @Nonnull ItemStack out) {
            this(in1, 0, ItemStack.field_190927_a, 0, out, 0, -1, -1);
        }

        public String toString() {
            return this.input1 + " + " + this.input2 + " => " + this.output;
        }

        public void func_190888_a(@Nonnull IMerchant merchant, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            int numTrades = -1;
            if (this.maxTrades > 0) {
                numTrades = this.maxTradeVariation > 0 ? Math.max(1, this.maxTrades + random.nextInt(this.maxTradeVariation) - this.maxTradeVariation / 2) : this.maxTrades;
            }
            ItemStack in1 = this.input1.func_77946_l();
            if (this.maxInputMarkup1 > 0) {
                in1.func_190920_e(in1.func_190916_E() + random.nextInt(this.maxInputMarkup1));
            }
            ItemStack in2 = ItemStack.field_190927_a;
            if (!this.input2.func_190926_b() && this.input2.func_77973_b() != null) {
                in2 = this.input2.func_77946_l();
                if (this.maxInputMarkup2 > 0) {
                    in2.func_190920_e(in2.func_190916_E() + random.nextInt(this.maxInputMarkup2));
                }
            }
            ItemStack out = this.output.func_77946_l();
            if (this.maxOutputMarkup > 0) {
                out.func_190920_e(out.func_190916_E() + random.nextInt(this.maxOutputMarkup));
            }
            if (numTrades > 0) {
                recipeList.add((Object)new MerchantRecipe(in1, in2, out, 0, numTrades));
            } else {
                recipeList.add((Object)new MerchantRecipe(in1, in2, out));
            }
        }
    }

    public static class MultiTradeGenerator
    implements EntityVillager.ITradeList {
        private final int numberOfTrades;
        private final EntityVillager.ITradeList[] trades;

        public MultiTradeGenerator(@Nonnull int tradeCount, @Nonnull List<EntityVillager.ITradeList> tradePalette) {
            this.numberOfTrades = Math.min(tradeCount, tradePalette.size());
            this.trades = tradePalette.toArray(new EntityVillager.ITradeList[tradePalette.size()]);
        }

        public void func_190888_a(@Nonnull IMerchant merchant, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            for (int n = 0; n < this.numberOfTrades; ++n) {
                this.trades[random.nextInt(this.trades.length)].func_190888_a(merchant, recipeList, random);
            }
        }

        public String toString() {
            return MultiTradeGenerator.class.getSimpleName() + ": " + this.numberOfTrades + " trades chosen from " + Arrays.toString(this.trades);
        }
    }
}

