/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.init;

import com.google.common.collect.Lists;
import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.MaterialStats;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.material.MMDMaterialType;
import com.mcmoddev.lib.util.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class Materials {
    private static final IForgeRegistry<MMDMaterial> REGISTRY = new RegistryBuilder().setName(new ResourceLocation("mmdlib", "materials_registry")).setType(MMDMaterial.class).setMaxID(0x7FFFFFF).create();
    public static final Materials instance = new Materials();
    private static final Map<MMDMaterial, ItemArmor.ArmorMaterial> armorMaterialMap = new HashMap<MMDMaterial, ItemArmor.ArmorMaterial>();
    private static final Map<MMDMaterial, Item.ToolMaterial> toolMaterialMap = new HashMap<MMDMaterial, Item.ToolMaterial>();
    public static final MMDMaterial EMPTY = Materials.createOrelessMaterial("empty", MMDMaterialType.MaterialType.METAL, 0.0, 0.0, 0.0, 0);
    public static final MMDMaterial DEFAULT = Materials.createOrelessMaterial("default", MMDMaterialType.MaterialType.METAL, 0.0, 0.0, 0.0, 0);

    protected Materials() {
    }

    public static void init() {
        Materials.createVanillaMaterial("wood", MMDMaterialType.MaterialType.WOOD, 2.0, 2.0, 6.0, -9874381);
        Materials.createVanillaMaterial("stone", MMDMaterialType.MaterialType.ROCK, 5.0, 4.0, 2.0, -7368817);
        Materials.createVanillaMaterial("iron", MMDMaterialType.MaterialType.METAL, 8.0, 8.0, 4.5, -2565928);
        Materials.createVanillaMaterial("gold", MMDMaterialType.MaterialType.METAL, 1.0, 1.0, 10.0, -117);
        Materials.createVanillaMaterial("diamond", MMDMaterialType.MaterialType.GEM, 10.0, 15.0, 4.0, -7539487);
        Materials.createVanillaMaterial("coal", MMDMaterialType.MaterialType.MINERAL, 4.0, 4.0, 2.0, -15395563);
        Materials.createVanillaMaterial("charcoal", MMDMaterialType.MaterialType.MINERAL, 4.0, 4.0, 2.0, -14475496);
        Materials.createVanillaMaterial("emerald", MMDMaterialType.MaterialType.GEM, 10.0, 15.0, 4.0, -8194388);
        Materials.createVanillaMaterial("ender", MMDMaterialType.MaterialType.GEM, 2.0, 2.0, 6.0, -16369359);
        Materials.createVanillaMaterial("quartz", MMDMaterialType.MaterialType.GEM, 5.0, 4.0, 2.0, -1383461);
        Materials.createVanillaMaterial("obsidian", MMDMaterialType.MaterialType.ROCK, 10.0, 15.0, 4.0, -15724519);
        Materials.createVanillaMaterial("lapis", MMDMaterialType.MaterialType.MINERAL, 1.0, 1.0, 1.0, -14261860);
        Materials.createVanillaMaterial("prismarine", MMDMaterialType.MaterialType.MINERAL, 1.0, 1.0, 1.0, -8406876);
        Materials.createVanillaMaterial("redstone", MMDMaterialType.MaterialType.MINERAL, 1.0, 1.0, 1.0, -9306112);
    }

    public static void dumpRegistry() {
        REGISTRY.getEntries().stream().forEach(ent -> MMDLib.logger.fatal("Material %s - %s (%s)", ent.getKey(), (Object)((MMDMaterial)((Object)((Object)ent.getValue()))).getCapitalizedName(), ent.getValue()));
    }

    protected static MMDMaterial createOrelessMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, @Nonnull double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor) {
        MMDMaterialType matType = new MMDMaterialType("Oreless", type, MMDMaterialType.VariantType.ORELESS);
        MMDMaterial material = new MMDMaterial(name, matType, (float)hardness, (float)strength, (float)magic, tintColor, false, false);
        return Materials.registerMaterial(material);
    }

    protected static MMDMaterial createVanillaMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, @Nonnull double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor) {
        MMDMaterialType matType = new MMDMaterialType("Vanilla", type, MMDMaterialType.VariantType.ORELESS, MMDMaterialType.VariantType.VANILLA);
        MMDMaterial material = new MMDMaterial(name, matType, (float)hardness, (float)strength, (float)magic, tintColor, false, false);
        return Materials.registerMaterial(material);
    }

    protected static MMDMaterial createMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, @Nonnull double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor) {
        return Materials.createMaterial(name, type, hardness, strength, magic, tintColor, false);
    }

    protected static MMDMaterial createMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, @Nonnull double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor, @Nonnull boolean customFluid) {
        MMDMaterialType matType = new MMDMaterialType("Standard", type, MMDMaterialType.VariantType.NORMAL);
        MMDMaterial material = new MMDMaterial(name, matType, (float)hardness, (float)strength, (float)magic, tintColor, true, false, customFluid);
        return Materials.registerMaterial(material);
    }

    protected static MMDMaterial createAlloyMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, @Nonnull double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor) {
        MMDMaterialType matType = new MMDMaterialType("Standard Alloy", type, MMDMaterialType.VariantType.ALLOY);
        MMDMaterial material = new MMDMaterial(name, matType, (float)hardness, (float)strength, (float)magic, tintColor, false, true);
        return Materials.registerMaterial(material);
    }

    protected static MMDMaterial createSpecialMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, @Nonnull double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor) {
        MMDMaterialType matType = new MMDMaterialType("Special", type, MMDMaterialType.VariantType.SPECIAL);
        MMDMaterial material = new MMDMaterial(name, matType, (float)hardness, (float)strength, (float)magic, tintColor, true, true);
        return Materials.registerMaterial(material);
    }

    protected static MMDMaterial createOrelessRareMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, @Nonnull double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor) {
        MMDMaterialType matType = new MMDMaterialType("Rare Oreless", type, MMDMaterialType.VariantType.RARE, MMDMaterialType.VariantType.ORELESS);
        MMDMaterial material = new MMDMaterial(name, matType, (float)hardness, (float)strength, (float)magic, tintColor, false, false);
        return Materials.registerMaterial(material);
    }

    protected static MMDMaterial createRareMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, @Nonnull double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor) {
        MMDMaterialType matType = new MMDMaterialType("Basic Rare", type, MMDMaterialType.VariantType.RARE, MMDMaterialType.VariantType.NORMAL);
        MMDMaterial material = new MMDMaterial(name, matType, (float)hardness, (float)strength, (float)magic, tintColor, true, false);
        return Materials.registerMaterial(material);
    }

    protected static MMDMaterial createRareAlloyMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor) {
        MMDMaterialType matType = new MMDMaterialType("Rare Alloy", type, MMDMaterialType.VariantType.RARE, MMDMaterialType.VariantType.ALLOY);
        MMDMaterial material = new MMDMaterial(name, matType, (float)hardness, (float)strength, (float)magic, tintColor, false, true);
        return Materials.registerMaterial(material);
    }

    protected static MMDMaterial createRareSpecialMaterial(@Nonnull String name, @Nonnull MMDMaterialType.MaterialType type, @Nonnull double hardness, @Nonnull double strength, @Nonnull double magic, @Nonnull int tintColor) {
        MMDMaterialType matType = new MMDMaterialType("Special Rare Alloy", type, MMDMaterialType.VariantType.RARE, MMDMaterialType.VariantType.ALLOY, MMDMaterialType.VariantType.SPECIAL);
        MMDMaterial material = new MMDMaterial(name, matType, (float)hardness, (float)strength, (float)magic, tintColor, true, true);
        return Materials.registerMaterial(material);
    }

    protected static MMDMaterial registerMaterial(@Nonnull MMDMaterial material) {
        ResourceLocation loc = new ResourceLocation(Loader.instance().activeModContainer().getModId(), material.getName());
        if (REGISTRY.containsKey(loc)) {
            MMDLib.logger.error("You asked registermaterial() to register an existing material, Don't do that! (Returning pre existing material instead");
            return Materials.getMaterialByName(material.getName());
        }
        material.setRegistryName(loc);
        REGISTRY.register((IForgeRegistryEntry)material);
        String enumName = material.getEnumName();
        String texName = material.getName();
        int[] protection = material.getDamageReductionArray();
        int durability = material.getArmorMaxDamageFactor();
        ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)enumName, (String)texName, (int)durability, (int[])protection, (int)material.getEnchantability(), (SoundEvent)SoundEvents.field_187725_r, (float)(material.getStat(MaterialStats.HARDNESS) > 10.0f ? (float)((int)(material.getStat(MaterialStats.HARDNESS) / 5.0f)) : 0.0f));
        if (armorMaterial == null) {
            MMDLib.logger.error("Failed to create armor material enum for " + (Object)((Object)material));
        }
        armorMaterialMap.put(material, armorMaterial);
        Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)enumName, (int)material.getToolHarvestLevel(), (int)material.getToolDurability(), (float)material.getToolEfficiency(), (float)material.getBaseAttackDamage(), (int)material.getEnchantability());
        if (toolMaterial == null) {
            MMDLib.logger.error("Failed to create tool material enum for " + (Object)((Object)material));
        }
        toolMaterialMap.put(material, toolMaterial);
        return material;
    }

    @Nullable
    public static ItemArmor.ArmorMaterial getArmorMaterialFor(@Nonnull MMDMaterial material) {
        return armorMaterialMap.get((Object)material);
    }

    @Nullable
    public static Item.ToolMaterial getToolMaterialFor(@Nonnull MMDMaterial material) {
        return toolMaterialMap.get((Object)material);
    }

    public static Collection<MMDMaterial> getAllMaterials() {
        return Collections.unmodifiableList(REGISTRY.getEntries().stream().map(ent -> (MMDMaterial)((Object)((Object)ent.getValue()))).collect(Collectors.toList()));
    }

    @Nonnull
    public static MMDMaterial getMaterialByName(@Nonnull String materialName) {
        for (ResourceLocation key : REGISTRY.getKeys()) {
            if (!key.func_110623_a().equals(materialName)) continue;
            return (MMDMaterial)REGISTRY.getValue(key);
        }
        return EMPTY;
    }

    public static Collection<MMDMaterial> getMaterialsByMod(@Nonnull String modId) {
        return Lists.newArrayList(REGISTRY.getEntries().stream().filter(ent -> ((ResourceLocation)ent.getKey()).func_110624_b().equals(modId)).map(Map.Entry::getValue).iterator());
    }

    public static boolean hasMaterial(@Nonnull String materialName) {
        MMDMaterial material = Materials.getMaterialByName(materialName);
        return material.getName().equals(materialName) && Config.Options.isMaterialEnabled(materialName);
    }

    public static boolean hasMaterialFromMod(@Nonnull String modId) {
        for (ResourceLocation rl : REGISTRY.getKeys()) {
            if (!rl.func_110624_b().equals(modId)) continue;
            return true;
        }
        return false;
    }
}

