/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.init;

import com.mcmoddev.lib.init.Items;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MMDCreativeTab
extends CreativeTabs {
    private ItemStack iconItem;
    private final boolean searchable;
    private Comparator<ItemStack> comparator;

    public MMDCreativeTab(@Nonnull String unlocalizedName, @Nonnull boolean searchable) {
        this(unlocalizedName, searchable, ItemStack.field_190927_a);
    }

    public MMDCreativeTab(@Nonnull String unlocalizedName, @Nonnull boolean searchable, @Nullable Block iconBlock) {
        this(unlocalizedName, searchable, iconBlock != null ? new ItemStack(Item.func_150898_a((Block)iconBlock)) : ItemStack.field_190927_a);
    }

    public MMDCreativeTab(@Nonnull String unlocalizedName, @Nonnull boolean searchable, @Nullable Item iconItem) {
        this(unlocalizedName, searchable, iconItem != null ? new ItemStack(iconItem) : ItemStack.field_190927_a);
    }

    public MMDCreativeTab(@Nonnull String unlocalizedName, @Nonnull boolean searchable, @Nonnull ItemStack iconItem) {
        super(unlocalizedName);
        this.iconItem = iconItem.func_190926_b() ? new ItemStack(net.minecraft.init.Items.field_151035_b) : iconItem;
        this.searchable = searchable;
        this.setSortingAlgorithm((first, second) -> {
            int delta = Items.getSortingValue(first) - Items.getSortingValue(second);
            return delta == 0 ? first.func_77977_a().compareToIgnoreCase(second.func_77977_a()) : delta;
        });
        if (searchable) {
            this.func_78025_a("item_search.png");
        }
    }

    public boolean hasSearchBar() {
        return this.searchable;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78018_a(@Nonnull NonNullList<ItemStack> itemList) {
        super.func_78018_a(itemList);
        if (this.comparator != null) {
            itemList.sort(this.comparator);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_78016_d() {
        return this.iconItem;
    }

    public void setSortingAlgorithm(@Nonnull Comparator<ItemStack> comparator) {
        this.comparator = comparator;
    }

    public void setTabIconItem(@Nonnull Block iconBlock) {
        this.iconItem = new ItemStack(Item.func_150898_a((Block)iconBlock));
    }

    public void setTabIconItem(@Nonnull Item iconItem) {
        this.iconItem = new ItemStack(iconItem);
    }

    public void setTabIconItem(@Nonnull ItemStack iconItem) {
        this.iconItem = iconItem;
    }
}

