/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.init;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.init.Items;
import com.mcmoddev.lib.init.MMDCreativeTab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class ItemGroups {
    public static final BiFunction<ItemStack, ItemStack, Integer> sortingAlgorithm = (a, b) -> {
        int delta = Items.getSortingValue(a) - Items.getSortingValue(b);
        if (delta == 0) {
            return a.func_77973_b().func_77658_a().compareToIgnoreCase(b.func_77973_b().func_77658_a());
        }
        return delta;
    };
    private static final Map<String, MMDCreativeTab> itemGroupsByFullTabName = new HashMap<String, MMDCreativeTab>();
    private static final Map<String, List<MMDCreativeTab>> itemGroupsByModID = new HashMap<String, List<MMDCreativeTab>>();

    protected ItemGroups() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
    }

    protected static MMDCreativeTab addTab(@Nonnull String name) {
        return ItemGroups.addTab(name, false);
    }

    protected static MMDCreativeTab addTab(@Nonnull String name, @Nonnull boolean searchable) {
        String modName = Loader.instance().activeModContainer().getModId();
        String internalTabName = String.format("%s.%s", modName, name);
        if (itemGroupsByFullTabName.containsKey(internalTabName)) {
            return itemGroupsByFullTabName.get(internalTabName);
        }
        MMDCreativeTab tab = new MMDCreativeTab(internalTabName, searchable);
        if (!itemGroupsByFullTabName.containsKey(modName)) {
            itemGroupsByFullTabName.put(internalTabName, tab);
        }
        if (itemGroupsByModID.containsKey(modName)) {
            itemGroupsByModID.get(modName).add(tab);
        } else {
            ArrayList<MMDCreativeTab> nl = new ArrayList<MMDCreativeTab>();
            nl.add(tab);
            itemGroupsByModID.put(modName, nl);
        }
        return itemGroupsByFullTabName.get(internalTabName);
    }

    public static void dumpTabs() {
        MMDLib.logger.fatal("CREATIVE TABS (by internal reference name):");
        itemGroupsByFullTabName.entrySet().stream().forEach(ent -> MMDLib.logger.fatal("Tab fullname: %s, object: %s", ent.getKey(), ent.getValue()));
        MMDLib.logger.fatal("CREATIVE TABS (by mod-id reference name):");
        itemGroupsByModID.entrySet().stream().forEach(ent -> {
            MMDLib.logger.fatal("Mod %s", ent.getKey());
            ((List)ent.getValue()).stream().forEach(tab -> MMDLib.logger.fatal("tab name: %s is %s", (Object)tab.func_78013_b(), (Object)tab));
        });
    }

    @Nullable
    public static MMDCreativeTab getTab(@Nonnull String name) {
        String modName = Loader.instance().activeModContainer().getModId();
        return ItemGroups.getTab(modName, name);
    }

    @Nullable
    public static MMDCreativeTab getTab(@Nonnull String modName, @Nonnull String name) {
        String finalName = String.format("%s.%s", modName, name);
        return itemGroupsByFullTabName.getOrDefault(finalName, ItemGroups.addTab(name, true));
    }

    public static Map<String, List<MMDCreativeTab>> getItemsGroupsByModID() {
        return Collections.unmodifiableMap(itemGroupsByModID);
    }
}

