/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.feature;

import com.mcmoddev.lib.energy.ForgeEnergyStorage;
import com.mcmoddev.lib.feature.BaseFeature;
import com.mcmoddev.lib.feature.FeatureDirtyLevel;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class SimpleWorkFeature
extends BaseFeature
implements ITickable {
    private final Supplier<Integer> canStartDelegate;
    private final Supplier<Boolean> endProcessDelegate;
    private final ForgeEnergyStorage battery;
    private final int batteryDischargeRate;
    private boolean isRunning = false;
    private int totalEnergyRequired = 0;
    private int currentEnergy = 0;

    public SimpleWorkFeature(String key, ForgeEnergyStorage battery, int batteryDischargeRate, Supplier<Integer> canStartDelegate, Supplier<Boolean> endProcessDelegate) {
        super(key);
        this.battery = battery;
        this.batteryDischargeRate = batteryDischargeRate;
        this.canStartDelegate = canStartDelegate;
        this.endProcessDelegate = endProcessDelegate;
    }

    @Override
    protected void writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("is_running", this.isRunning);
        tag.func_74768_a("required_energy", this.totalEnergyRequired);
        tag.func_74768_a("energy", this.currentEnergy);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.isRunning = nbt.func_74767_n("is_running");
        this.totalEnergyRequired = nbt.func_74762_e("required_energy");
        this.currentEnergy = nbt.func_74762_e("energy");
    }

    public void func_73660_a() {
        int toConsume;
        int energyRequired;
        if (!this.isRunning && (energyRequired = this.canStartDelegate.get().intValue()) > 0) {
            this.isRunning = true;
            this.totalEnergyRequired = energyRequired;
            this.currentEnergy = 0;
            this.setDirty(FeatureDirtyLevel.GUI);
        }
        if (this.isRunning && ((toConsume = Math.min(this.batteryDischargeRate, this.totalEnergyRequired - this.currentEnergy)) <= 0 || this.battery.take(toConsume, false) > 0)) {
            int taken;
            int n = taken = toConsume > 0 ? this.battery.take(toConsume, true) : 0;
            if (taken > 0) {
                this.currentEnergy += taken;
                this.setDirty(FeatureDirtyLevel.GUI);
            }
            if (this.currentEnergy >= this.totalEnergyRequired && this.endProcessDelegate.get().booleanValue()) {
                this.isRunning = false;
                this.totalEnergyRequired = 0;
                this.currentEnergy = 0;
                this.setDirty(FeatureDirtyLevel.GUI);
            }
        }
    }
}

