/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.feature;

import com.mcmoddev.lib.feature.FeatureDirtyLevel;
import com.mcmoddev.lib.feature.IFeature;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public interface IFeatureHolder {
    public <T extends IFeature> T addFeature(T var1);

    public IFeature[] getFeatures();

    public void featureChanged(IFeature var1, FeatureDirtyLevel var2);

    @Nullable
    default public IFeature getFeature(String key) {
        for (IFeature feature : this.getFeatures()) {
            if (!feature.getKey().equals(key)) continue;
            return feature;
        }
        return null;
    }

    @Nullable
    default public <T extends IFeature> T getTypedFeature(Class<T> expectedType, String key) {
        for (IFeature feature : this.getFeatures()) {
            if (!feature.getKey().equals(key) || !expectedType.isAssignableFrom(feature.getClass())) continue;
            return (T)((IFeature)expectedType.cast(feature));
        }
        return null;
    }

    @Nullable
    default public <T extends IFeature> T findTypedFeature(Class<T> expectedType) {
        for (IFeature feature : this.getFeatures()) {
            if (!expectedType.isAssignableFrom(feature.getClass())) continue;
            return (T)((IFeature)expectedType.cast(feature));
        }
        return null;
    }

    default public <T extends IFeature> List<T> findTypedFeatures(Class<T> expectedType) {
        ArrayList<T> list = new ArrayList<T>();
        for (IFeature feature : this.getFeatures()) {
            if (!expectedType.isAssignableFrom(feature.getClass())) continue;
            list.add(expectedType.cast(feature));
        }
        return list;
    }
}

