/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.feature;

import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.gui.BaseWidgetGui;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.gui.GuiPieceLayer;
import com.mcmoddev.lib.container.gui.GuiSprites;
import com.mcmoddev.lib.container.gui.IGuiSprite;
import com.mcmoddev.lib.container.gui.IWidgetGui;
import com.mcmoddev.lib.container.gui.MMDGuiContainer;
import com.mcmoddev.lib.container.gui.SpriteBackgroundGui;
import com.mcmoddev.lib.container.gui.layout.CanvasLayout;
import com.mcmoddev.lib.container.gui.util.Size2D;
import com.mcmoddev.lib.energy.ForgeEnergyStorage;
import com.mcmoddev.lib.feature.BaseFeature;
import com.mcmoddev.lib.feature.FeatureDirtyLevel;
import com.mcmoddev.lib.feature.IClientFeature;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ForgeEnergyBatteryFeature
extends BaseFeature
implements ICapabilityProvider,
IClientFeature,
IWidgetContainer {
    public static final int DEFAULT_INPUT_OUTPUT_RATE = 120;
    private final ForgeEnergyStorage battery;

    public ForgeEnergyBatteryFeature(String key, int capacity) {
        this(key, 0, capacity);
    }

    public ForgeEnergyBatteryFeature(String key, int initial, int capacity) {
        this(key, initial, capacity, 120, 120);
    }

    public ForgeEnergyBatteryFeature(String key, int initial, int capacity, int inputRate, int outputRate) {
        super(key);
        this.battery = new ForgeEnergyStorage(initial, capacity){

            @Override
            protected void onChanged() {
                super.onChanged();
                ForgeEnergyBatteryFeature.this.setDirty(FeatureDirtyLevel.GUI);
            }
        };
        this.battery.setInputRate(inputRate);
        this.battery.setoutputRate(outputRate);
    }

    public ForgeEnergyStorage getEnergyStorage() {
        return this.battery;
    }

    @Override
    protected void writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a("battery", (NBTBase)this.battery.serializeNBT());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("battery", 10)) {
            this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.battery.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return this.battery.getCapability(capability, facing);
    }

    @Override
    public IWidgetGui getRootWidgetGui(GuiContext context) {
        CanvasLayout layout = new CanvasLayout();
        layout.addPiece(new SpriteBackgroundGui(GuiSprites.TANK_CONTAINER), 0, 0);
        layout.addPiece(new SpriteBackgroundGui(GuiSprites.ENERGY_RF_EMPTY), 3, 3);
        layout.addPiece(new ForgeEnergyWidgetGui(GuiSprites.ENERGY_RF_FULL), 3, 3);
        return layout;
    }

    private class ForgeEnergyWidgetGui
    extends BaseWidgetGui {
        private final IGuiSprite sprite;

        ForgeEnergyWidgetGui(IGuiSprite sprite) {
            super(sprite.getWidth(), sprite.getHeight());
            this.sprite = sprite;
        }

        @Override
        public GuiPieceLayer getLayer() {
            return GuiPieceLayer.MIDDLE;
        }

        @Override
        public void drawMiddleLayer(MMDGuiContainer container, float partialTicks, int mouseX, int mouseY) {
            float percent = MathHelper.func_76131_a((float)((float)((Integer)ForgeEnergyBatteryFeature.this.battery.getStored()).intValue() / (float)((Integer)ForgeEnergyBatteryFeature.this.battery.getCapacity()).intValue()), (float)0.0f, (float)1.0f);
            if (percent > 0.0f) {
                Size2D size = this.getSize();
                int top = Math.round((1.0f - percent) * (float)size.height);
                this.sprite.draw((GuiScreen)container, 0, top, 0, top, size.width, size.height - top);
            }
        }

        @Override
        public void getTooltip(List<String> lines) {
            if ((Integer)ForgeEnergyBatteryFeature.this.battery.getStored() == 0) {
                lines.add(TextFormatting.DARK_GRAY + "EMPTY BATTERY");
            } else {
                lines.add(TextFormatting.AQUA + ForgeEnergyBatteryFeature.this.battery.getStoredValue().toString());
            }
            if ((Integer)ForgeEnergyBatteryFeature.this.battery.getInputRate() == 0) {
                lines.add(TextFormatting.DARK_GRAY + "[no input allowed]");
            } else {
                lines.add(TextFormatting.WHITE + "Input Rate: " + TextFormatting.DARK_AQUA + ForgeEnergyBatteryFeature.this.battery.getInputRateValue().toString());
            }
            if ((Integer)ForgeEnergyBatteryFeature.this.battery.getOutputRate() == 0) {
                lines.add(TextFormatting.DARK_GRAY + "[no output allowed]");
            } else {
                lines.add(TextFormatting.WHITE + "Output Rate: " + TextFormatting.DARK_AQUA + ForgeEnergyBatteryFeature.this.battery.getOutputRateValue().toString());
            }
        }
    }
}

