/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.feature;

import com.google.common.collect.Lists;
import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.gui.IWidgetGui;
import com.mcmoddev.lib.container.gui.layout.VerticalStackLayout;
import com.mcmoddev.lib.container.widget.IWidget;
import com.mcmoddev.lib.feature.FeatureDirtyLevel;
import com.mcmoddev.lib.feature.IFeature;
import com.mcmoddev.lib.feature.IFeatureHolder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseItemStackFeatureHolder
implements IFeatureHolder,
IWidgetContainer {
    private final ItemStack stack;
    private final List<IFeature> features = Lists.newArrayList();

    public BaseItemStackFeatureHolder(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public <T extends IFeature> T addFeature(T feature) {
        this.features.add(feature);
        feature.setHolder(this);
        NBTTagCompound storage = this.stack.func_190925_c("features");
        if (storage.func_150297_b(feature.getKey(), 10)) {
            NBTTagCompound featureCompound = storage.func_74775_l(feature.getKey());
            feature.deserializeNBT((NBTBase)featureCompound);
        }
        return feature;
    }

    @Override
    public IFeature[] getFeatures() {
        return this.features.toArray(new IFeature[this.features.size()]);
    }

    @Override
    public void featureChanged(IFeature feature, FeatureDirtyLevel level) {
        NBTTagCompound featureCompound = (NBTTagCompound)feature.serializeNBT();
        NBTTagCompound storage = this.stack.func_190925_c("features");
        storage.func_74782_a(feature.getKey(), (NBTBase)featureCompound);
    }

    private Stream<IWidget> getWidgetsStream(GuiContext context) {
        return this.features.stream().map(f -> f instanceof IWidgetContainer ? (IWidgetContainer)IWidgetContainer.class.cast(f) : null).filter(Objects::nonNull).flatMap(c -> c.getWidgets(context).stream());
    }

    @Override
    public List<IWidget> getWidgets(GuiContext context) {
        return this.getWidgetsStream(context).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public NBTTagCompound getGuiUpdateTag(boolean resetDirtyFlag) {
        NBTTagCompound nbt = new NBTTagCompound();
        return nbt.func_186856_d() > 0 ? nbt : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveGuiUpdateTag(NBTTagCompound compound) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IWidgetGui getRootWidgetGui(GuiContext context) {
        VerticalStackLayout layout = new VerticalStackLayout();
        for (IFeature feature : this.features) {
            if (!(feature instanceof IWidgetContainer)) continue;
            IWidgetContainer provider = (IWidgetContainer)((Object)feature);
            layout.addPiece(provider.getRootWidgetGui(context));
        }
        return layout;
    }
}

