/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy;

import com.mcmoddev.lib.energy.IEnergySystem;
import java.util.Objects;

public interface IEnergyValue<T>
extends Comparable<IEnergyValue<T>> {
    public IEnergySystem<T> getSystem();

    public T getValue();

    public void setValue(T var1);

    default public boolean isCompatible(IEnergyValue other) {
        return this.getSystem().isCompatibleWith(other.getSystem());
    }

    public IEnergyValue<T> add(IEnergyValue var1);

    public IEnergyValue<T> subtract(IEnergyValue var1);

    @Override
    default public int compareTo(IEnergyValue<T> other) {
        T energy = this.getValue();
        T compareTo = Objects.requireNonNull(this.getSystem().convertFrom(other)).getValue();
        if (energy instanceof Comparable && compareTo instanceof Comparable) {
            return ((Comparable)Comparable.class.cast(energy)).compareTo(compareTo);
        }
        return 0;
    }

    public IEnergyValue<T> copy();
}

