/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.widget;

import com.google.common.collect.Lists;
import com.mcmoddev.lib.container.IContainerSlot;
import com.mcmoddev.lib.container.PlayerInventory;
import com.mcmoddev.lib.container.slot.PlayerInventorySlot;
import com.mcmoddev.lib.container.widget.BaseWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerInventoryWidget
extends BaseWidget {
    private final PlayerInventory[] inventories;
    private final EntityPlayer player;
    private List<IContainerSlot> cachedSlots = null;

    public PlayerInventoryWidget(String key, EntityPlayer player, PlayerInventory ... inventories) {
        super(key, false);
        this.player = player;
        this.inventories = inventories;
    }

    @Override
    public Collection<IContainerSlot> getSlots() {
        if (this.cachedSlots != null) {
            return this.cachedSlots;
        }
        ArrayList slots = Lists.newArrayList();
        for (PlayerInventory inventory : this.inventories) {
            slots.addAll(PlayerInventorySlot.createSlots(this.player, inventory));
        }
        this.cachedSlots = slots;
        return this.cachedSlots;
    }
}

