/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.capability;

import com.mcmoddev.lib.capability.ICapabilitiesContainer;
import com.mcmoddev.lib.inventory.CombinedFluidHandler;
import com.mcmoddev.lib.inventory.CombinedItemHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilitiesContainer
implements ICapabilitiesContainer,
ICapabilityProvider {
    private final List<CapabilityInfo<IItemHandler>> itemCaps = new ArrayList<CapabilityInfo<IItemHandler>>();
    private final List<CapabilityInfo<IFluidHandler>> fluidCaps = new ArrayList<CapabilityInfo<IFluidHandler>>();
    private final List<CapabilityInfo<?>> capabilities = new ArrayList();

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.capabilities.stream().anyMatch(c -> c.hasCapability(capability, facing));
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        for (ICapabilityProvider iCapabilityProvider : this.capabilities) {
            Object thing = iCapabilityProvider.getCapability(capability, facing);
            if (thing == null) continue;
            return (T)thing;
        }
        return null;
    }

    @Override
    public <T> void addCapability(Capability<T> capability, Function<EnumFacing, T> capabilitySupplier, @Nullable Predicate<EnumFacing> facingFilter) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemCaps.isEmpty()) {
                this.capabilities.add(new CapabilityInfo<IItemHandler>(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing -> {
                    CombinedItemHandler combined = new CombinedItemHandler(new IItemHandler[0]);
                    for (CapabilityInfo<IItemHandler> cap : this.itemCaps) {
                        IItemHandler handler = (IItemHandler)cap.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (EnumFacing)facing);
                        if (handler == null) continue;
                        combined.addItemHandler(handler);
                    }
                    return combined;
                }, null));
            }
            this.itemCaps.add(new CapabilityInfo<T>(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, capabilitySupplier, facingFilter));
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.fluidCaps.isEmpty()) {
                this.capabilities.add(new CapabilityInfo<IFluidHandler>(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing -> {
                    CombinedFluidHandler combined = new CombinedFluidHandler(new IFluidHandler[0]);
                    for (CapabilityInfo<IFluidHandler> cap : this.fluidCaps) {
                        IFluidHandler handler = (IFluidHandler)cap.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (EnumFacing)facing);
                        if (handler == null) continue;
                        combined.addFluidHandler(handler);
                    }
                    return combined;
                }, null));
            }
            this.fluidCaps.add(new CapabilityInfo<T>(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, capabilitySupplier, facingFilter));
        } else {
            this.capabilities.add(new CapabilityInfo<T>(capability, capabilitySupplier, facingFilter));
        }
    }

    private class CapabilityInfo<T>
    implements ICapabilityProvider {
        private final Capability<T> capability;
        private final Function<EnumFacing, T> capabilityGetter;
        private final Predicate<EnumFacing> sideFilter;

        CapabilityInfo(Capability<T> capability, @Nullable Function<EnumFacing, T> capabilityGetter, Predicate<EnumFacing> sideFilter) {
            this.capability = capability;
            this.capabilityGetter = capabilityGetter;
            this.sideFilter = sideFilter;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return (facing == null || this.sideFilter == null || this.sideFilter.test(facing)) && this.getCapability(capability, facing) != null;
        }

        @Nullable
        public <C> C getCapability(@Nonnull Capability<C> capability, @Nullable EnumFacing facing) {
            if (capability == this.capability && (this.sideFilter == null || this.sideFilter.test(facing))) {
                return (C)capability.cast(this.capabilityGetter.apply(facing));
            }
            return null;
        }
    }
}

