/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.block;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class InteractiveFluidBlock
extends BlockFluidClassic {
    private final BiConsumer<World, EntityLivingBase> immersionEffect;
    private final boolean isFlammable;

    public InteractiveFluidBlock(Fluid fluid, boolean flammable, @Nullable BiConsumer<World, EntityLivingBase> immersionEffect) {
        super(fluid, Material.field_151586_h);
        this.isFlammable = flammable;
        this.immersionEffect = immersionEffect;
    }

    public InteractiveFluidBlock(Fluid fluid, BiConsumer<World, EntityLivingBase> immersionEffect) {
        this(fluid, false, immersionEffect);
    }

    public InteractiveFluidBlock(Fluid fluid) {
        this(fluid, false, null);
    }

    public void func_180634_a(World world, BlockPos coord, IBlockState state, Entity entity) {
        super.func_180634_a(world, coord, state, entity);
        if (this.immersionEffect != null && entity instanceof EntityLivingBase) {
            this.immersionEffect.accept(world, (EntityLivingBase)entity);
        }
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isFlammable) {
            return 60;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isFlammable) {
            return 30;
        }
        return 0;
    }
}

