/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.block;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.item.MMDContainerRepair;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public class BlockMMDAnvil
extends BlockAnvil
implements IMMDObject {
    private final MMDMaterial mmdMaterial;

    public BlockMMDAnvil(MMDMaterial material) {
        this.mmdMaterial = material;
        this.func_149672_a(this.mmdMaterial.getSoundType());
        this.field_149782_v = this.mmdMaterial.getBlockHardness();
        this.field_149781_w = this.mmdMaterial.getBlastResistance();
        this.setHarvestLevel(this.mmdMaterial.getHarvestTool(), this.mmdMaterial.getRequiredHarvestLevel());
    }

    @Override
    public MMDMaterial getMMDMaterial() {
        return this.mmdMaterial;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.func_180468_a((IInteractionObject)new MMDAnvil(worldIn, pos, this.mmdMaterial));
        }
        return true;
    }

    public static class MMDAnvil
    implements IInteractionObject {
        private final World world;
        private final BlockPos position;
        private final MMDMaterial material;

        public MMDAnvil(World worldIn, BlockPos pos, MMDMaterial material) {
            this.world = worldIn;
            this.position = pos;
            this.material = material;
        }

        public String func_70005_c_() {
            return (Object)((Object)Names.ANVIL) + this.material.getCapitalizedName();
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.material.getBlock(Names.ANVIL) + ".name", new Object[0]);
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return new MMDContainerRepair(playerInventory, this.world, this.position, playerIn);
        }

        public String func_174875_k() {
            return "minecraft:anvil";
        }
    }
}

