/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.UpDownIntSelector;
import com.rwtema.extrautils2.gui.backend.WidgetText;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.particles.PacketParticleSplineCurve;
import com.rwtema.extrautils2.tile.IRemoteTarget;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import com.rwtema.extrautils2.utils.helpers.VecHelper;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileInteractionProxy
extends TilePower
implements ITickable,
IRemoteTarget,
IDynamicHandler {
    public static final Function<BlockPos, Integer> GET_X = Vec3i::func_177958_n;
    public static final Function<BlockPos, Integer> GET_Y = Vec3i::func_177956_o;
    public static final Function<BlockPos, Integer> GET_Z = Vec3i::func_177952_p;
    public static final BiConsumer<NBTSerializable.NBTMutableBlockPos, Integer> SET_POS_X = NBTSerializable.NBTMutableBlockPos::setPosX;
    public static final BiConsumer<NBTSerializable.NBTMutableBlockPos, Integer> SET_POS_Y = NBTSerializable.NBTMutableBlockPos::setPosY;
    public static final BiConsumer<NBTSerializable.NBTMutableBlockPos, Integer> SET_POS_Z = NBTSerializable.NBTMutableBlockPos::setPosZ;
    public static final Set<Capability<?>> VALID_CAPS = ImmutableSet.of((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (Object)CapabilityEnergy.ENERGY);
    public NBTSerializable.NBTMutableBlockPos targetA = this.registerNBT("target_a", new NBTSerializable.NBTMutableBlockPos());
    public NBTSerializable.NBTMutableBlockPos targetB = this.registerNBT("target_b", new NBTSerializable.NBTMutableBlockPos());
    public NBTSerializable.NBTMutableBlockPos currentPos = this.registerNBT("pos", new NBTSerializable.NBTMutableBlockPos());
    public NBTSerializable.Float power = this.registerNBT("power", new NBTSerializable.Float(0.0f));
    boolean searching;
    long time = -1L;

    @Override
    public void onPowerChanged() {
    }

    @Override
    public float getPower() {
        return this.power.value;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long totalWorldTime = this.field_145850_b.func_82737_E();
        if (totalWorldTime != this.time && totalWorldTime % 20L == 0L) {
            this.time = totalWorldTime;
            this.nextPos();
            this.markForUpdate();
            CompatHelper.notifyNeighbours(this.field_145850_b, this.field_174879_c, this.func_145838_q());
            this.func_70296_d();
            this.power.value = Math.abs(this.currentPos.func_177958_n()) + Math.abs(this.currentPos.func_177956_o()) + Math.abs(this.currentPos.func_177952_p());
        }
    }

    @Override
    @Nullable
    public Optional<Pair<World, BlockPos>> getTargetPos() {
        if (!this.active) {
            return Optional.empty();
        }
        this.verifyPos();
        if (this.currentPos.equals(BlockPos.field_177992_a)) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)this.field_145850_b, (Object)this.func_174877_v().func_177971_a((Vec3i)this.currentPos)));
    }

    public void verifyPos() {
        this.currentPos.func_181079_c(MathHelper.func_76125_a((int)this.currentPos.func_177958_n(), (int)Math.min(this.targetA.func_177958_n(), this.targetB.func_177958_n()), (int)Math.max(this.targetA.func_177958_n(), this.targetB.func_177958_n())), MathHelper.func_76125_a((int)this.currentPos.func_177956_o(), (int)Math.min(this.targetA.func_177956_o(), this.targetB.func_177956_o()), (int)Math.max(this.targetA.func_177956_o(), this.targetB.func_177956_o())), MathHelper.func_76125_a((int)this.currentPos.func_177952_p(), (int)Math.min(this.targetA.func_177952_p(), this.targetB.func_177952_p()), (int)Math.max(this.targetA.func_177952_p(), this.targetB.func_177952_p())));
    }

    public void nextPos() {
        this.verifyPos();
        if (this.tryAdvance(GET_X, SET_POS_X) && this.tryAdvance(GET_Z, SET_POS_Z)) {
            this.tryAdvance(GET_Y, SET_POS_Y);
        }
    }

    public boolean tryAdvance(Function<BlockPos, Integer> getter, BiConsumer<NBTSerializable.NBTMutableBlockPos, Integer> setter) {
        int t = getter.apply((BlockPos)this.currentPos);
        if (--t < getter.apply((BlockPos)this.targetA) && t < getter.apply((BlockPos)this.targetB)) {
            t = Math.max(getter.apply((BlockPos)this.targetA), getter.apply((BlockPos)this.targetB));
            setter.accept(this.currentPos, t);
            return true;
        }
        setter.accept(this.currentPos, t);
        return false;
    }

    @Override
    public void onSuccessfulInteract(World world, BlockPos pos, EnumFacing side, boolean success) {
        int VELOCITY = -8;
        if (success && world == this.func_145831_w()) {
            Vec3d start = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
            Vec3d startVel = VecHelper.addSide(Vec3d.field_186680_a, side.func_176734_d(), 8.0);
            NetworkHandler.sendToAllAround(new PacketParticleSplineCurve(start, new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), startVel, VecHelper.addSide(Vec3d.field_186680_a, side, -4.0), -7539486), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 40.0));
        }
    }

    @Override
    @Nullable
    public NBTTagCompound getSaveInfo() {
        return NBTSerializable.saveData(new NBTTagCompound(), (Map<String, INBTSerializable>)ImmutableMap.builder().put((Object)"targetA", (Object)this.targetA).put((Object)"targetB", (Object)this.targetB).build());
    }

    @Override
    public void loadSaveInfo(@Nonnull NBTTagCompound tag) {
        NBTSerializable.loadData(tag, (Map<String, INBTSerializable>)ImmutableMap.builder().put((Object)"targetA", (Object)this.targetA).put((Object)"targetB", (Object)this.targetB).build());
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        packet.writeVarInt(this.targetA.func_177958_n());
        packet.writeVarInt(this.targetA.func_177956_o());
        packet.writeVarInt(this.targetA.func_177952_p());
        packet.writeVarInt(this.targetB.func_177958_n());
        packet.writeVarInt(this.targetB.func_177956_o());
        packet.writeVarInt(this.targetB.func_177952_p());
        packet.writeVarInt(this.currentPos.func_177958_n());
        packet.writeVarInt(this.currentPos.func_177956_o());
        packet.writeVarInt(this.currentPos.func_177952_p());
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        this.targetA.func_181079_c(packet.readVarInt(), packet.readVarInt(), packet.readVarInt());
        this.targetB.func_181079_c(packet.readVarInt(), packet.readVarInt(), packet.readVarInt());
        this.currentPos.func_181079_c(packet.readVarInt(), packet.readVarInt(), packet.readVarInt());
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerInteractionProxy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (this.searching || this.field_145850_b.field_72995_K || !VALID_CAPS.contains(capability)) {
            return null;
        }
        BlockPos add = this.func_174877_v().func_177971_a((Vec3i)this.currentPos);
        if (this.func_174877_v().equals((Object)add) || !this.field_145850_b.func_175667_e(add)) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(add);
        if (tileEntity == null) {
            return null;
        }
        try {
            this.searching = true;
            Object object = tileEntity.hasCapability(capability, facing) ? tileEntity.getCapability(capability, facing) : null;
            return (T)object;
        }
        finally {
            this.searching = false;
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public static class ContainerInteractionProxy
    extends DynamicContainerTile {
        public ContainerInteractionProxy(final TileInteractionProxy tile) {
            super(tile);
            this.addTitle(tile);
            this.crop();
            this.addWidget(new WidgetTextData(5, this.height, 152){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    packet.writeBlockPos(tile.func_174877_v());
                }

                @Override
                protected String constructText(XUPacketBuffer packet) {
                    BlockPos blockPos = packet.readBlockPos();
                    return Lang.translateArgs("Origin: [%s, %s, %s]", StringHelper.format(blockPos.func_177958_n()), StringHelper.format(blockPos.func_177956_o()), StringHelper.format(blockPos.func_177952_p()));
                }
            });
            this.crop();
            this.addWidget(new WidgetTextData(5, this.height, 152){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    packet.writeBlockPos(tile.func_174877_v().func_177971_a((Vec3i)tile.currentPos));
                }

                @Override
                protected String constructText(XUPacketBuffer packet) {
                    BlockPos blockPos = packet.readBlockPos();
                    return Lang.translateArgs("Scanning: [%s, %s, %s]", StringHelper.format(blockPos.func_177958_n()), StringHelper.format(blockPos.func_177956_o()), StringHelper.format(blockPos.func_177952_p()));
                }
            });
            this.crop(5);
            int w = 45;
            for (final NBTSerializable.NBTMutableBlockPos mutableBlockPos : ImmutableList.of((Object)tile.targetA, (Object)tile.targetB)) {
                int x = 4;
                this.addWidget(new WidgetText(x, this.height, tile.targetA == mutableBlockPos ? Lang.translate("Block Range Start") : Lang.translate("Block Range End")));
                this.crop();
                for (final Pair pair : ImmutableList.of((Object)Pair.of(GET_X, SET_POS_X), (Object)Pair.of(GET_Y, SET_POS_Y), (Object)Pair.of(GET_Z, SET_POS_Z))) {
                    new UpDownIntSelector(x, this.height, w){

                        @Override
                        public int getValue() {
                            return (Integer)((Function)pair.getLeft()).apply(mutableBlockPos);
                        }

                        @Override
                        public void setValue(int val) {
                            ((BiConsumer)pair.getRight()).accept(mutableBlockPos, val);
                        }
                    }.forEach(this::addWidget);
                    x += w + 4;
                }
                this.crop();
                this.height += 8;
            }
            this.crop();
            this.validate();
        }
    }
}

