/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power;

import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class PowerMultipliers {
    public static final IWorldPowerMultiplier SOLAR = new IWorldPowerMultiplier(){

        @Override
        public float multiplier(World world) {
            if (world == null) {
                return 0.0f;
            }
            return !PowerMultipliers.isDaytime(world) ? 0.0f : (world.func_72896_J() ? 0.95f : 1.0f);
        }

        public String toString() {
            return "SOLAR";
        }
    };
    public static final IWorldPowerMultiplier LUNAR = new IWorldPowerMultiplier(){

        @Override
        public float multiplier(World world) {
            if (world == null) {
                return 0.0f;
            }
            return !PowerMultipliers.isDaytime(world) ? 1.0f + world.func_130001_d() * 0.25f : 0.0f;
        }

        public String toString() {
            return "LUNAR";
        }
    };
    public static final IWorldPowerMultiplier WIND = new IWorldPowerMultiplier(){
        private static final int TIME_POWER = 8;
        private static final int MASK = 255;
        private static final float TIME_DIVISOR = 256.0f;
        private static final int RESULT_POW = 8;
        private static final int RESULT_MASK = 255;
        private static final float RESULT_DIVISOR = 256.0f;

        @Override
        public float multiplier(World world) {
            if (world == null) {
                return 0.0f;
            }
            long t = world.func_82737_E();
            float v = (float)((int)t & 0xFF) / 256.0f;
            long k = t >> 8;
            long a = (k += (long)world.field_73011_w.getDimension() * 31L) * k * 42317861L + k * 11L;
            long b = a + (2L * k + 1L) * 42317861L + 11L;
            float ai = (float)((int)(a & 0xFFL)) / 256.0f;
            float bi = (float)((int)(b & 0xFFL)) / 256.0f;
            float v1 = ai + (bi - ai) * v;
            return 0.5f + v1 * 2.0f + (float)(world.func_72896_J() ? 1 : 0) + (float)(world.func_72911_I() ? 2 : 0);
        }

        public String toString() {
            return "WIND";
        }
    };

    public static boolean isDaytime(World world) {
        return MathHelper.func_76134_b((float)(world.func_72826_c(1.0f) * ((float)Math.PI * 2))) >= 0.0f;
    }
}

