/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineRegistry;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.machine.BlockMachine;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockMachine
extends XUItemBlock {
    BlockMachine machine;

    public ItemBlockMachine(Block block) {
        super(block);
        this.machine = (BlockMachine)block;
        this.func_77627_a(true);
    }

    @Nullable
    public static Machine getMachineType(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        return tagCompound != null ? MachineRegistry.getMachine(tagCompound.func_74779_i("Type")) : null;
    }

    @Override
    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        Machine type = ItemBlockMachine.getMachineType(stack);
        return BlockMachine.getDisplayName(type);
    }

    @Override
    @Nonnull
    public EnumActionResult onItemUse(ItemStack stack, @Nonnull EntityPlayer playerIn, World worldIn, @Nonnull BlockPos pos, EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!stack.func_77942_o()) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block1 = iblockstate.func_177230_c();
        if (!block1.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (StackHelper.getStacksize(stack) != 0 && playerIn.func_175151_a(pos, facing, stack) && CompatHelper.canPlaceBlockHere(worldIn, this.field_150939_a, pos, false, facing, null, stack)) {
            int i = this.func_77647_b(stack.func_77960_j());
            Machine machine = ItemBlockMachine.getMachineType(stack);
            if (machine == null) {
                return EnumActionResult.FAIL;
            }
            Machine.EnergyMode mode = machine.energyMode;
            IBlockState iblockstate1 = this.machine.xuBlockState.getStateFromDropMeta(i).func_177226_a((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL, (Comparable)playerIn.func_174811_aO()).func_177226_a((IProperty)BlockMachine.ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a(BlockMachine.TYPE, (Comparable)((Object)mode));
            if (this.myPlaceBlockAt(stack, playerIn, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                SoundType soundtype = this.field_150939_a.func_185467_w();
                worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                StackHelper.decrease(stack);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        Machine machine = ItemBlockMachine.getMachineType(stack);
        if (machine == null) {
            return false;
        }
        Machine.EnergyMode mode = machine.energyMode;
        IBlockState iblockstate1 = this.machine.xuBlockState.defaultState.func_177226_a((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL, (Comparable)side).func_177226_a((IProperty)BlockMachine.ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a(BlockMachine.TYPE, (Comparable)((Object)mode));
        return super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, iblockstate1);
    }

    public boolean myPlaceBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.field_150939_a) {
            ItemBlockMachine.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            this.field_150939_a.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }
}

