/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.tile.TileTerraformer;
import com.rwtema.extrautils2.tile.TileTerraformerClimograph;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class BlockTerraformer
extends XUBlockStatic {
    public static final PropertyEnumSimple<Type> TYPE = new PropertyEnumSimple<Type>(Type.class);
    public static final List<Pair<Type, Type>> OPPOSITES;

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addDropProperties(new IProperty[]{TYPE}).build();
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        BoxModel model;
        Type value = (Type)((Object)state.func_177229_b(TYPE));
        switch (value) {
            case ANTENNA: {
                model = new BoxModel();
                model.addBoxI(2, 0, 2, 14, 1, 14, "terraformer/antenna_base");
                model.addBoxI(7, 1, 7, 9, 6, 9, "terraformer/antenna_side");
                model.addBoxI(4, 6, 6, 12, 10, 10, "terraformer/antenna_top");
                model.addBoxI(6, 6, 4, 10, 10, 12, "terraformer/antenna_top");
                for (int i = 0; i < 4; ++i) {
                    model.addBoxI(0, 5, 6, 4, 16, 10, "terraformer/antenna_side").setTextureSides(EnumFacing.UP, "terraformer/antenna_top", EnumFacing.DOWN, "terraformer/antenna_top").rotateY(i);
                }
                break;
            }
            case CLIMOGRAPH_BASE: {
                model = BoxModel.newStandardBlock("terraformer/terraformer_side").setTextures(EnumFacing.DOWN, "terraformer/terraformer_base");
                break;
            }
            default: {
                model = BoxModel.newStandardBlock("terraformer/" + value.name().toLowerCase(Locale.ENGLISH));
                model.setTextures(EnumFacing.UP, "terraformer/terraformer_side", EnumFacing.DOWN, "terraformer/terraformer_base");
            }
        }
        return model;
    }

    public boolean hasTileEntity(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(BlockTerraformer.TYPE))).te != null;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        Supplier<? extends XUTile> te = ((Type)((Object)state.func_177229_b(BlockTerraformer.TYPE))).te;
        return te != null ? (TileEntity)te.get() : null;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Type type = (Type)((Object)this.xuBlockState.getStateFromItemStack(stack).func_177229_b((IProperty)TYPE));
        if (type != Type.CONTROLLER && type != Type.ANTENNA && type != Type.CLIMOGRAPH_BASE) {
            tooltip.add(Lang.translate("Climograph"));
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Pair.of((Object)((Object)Type.HEATER), (Object)((Object)Type.COOLER)));
        builder.add((Object)Pair.of((Object)((Object)Type.HUMIDIFIER), (Object)((Object)Type.DEHUMIDIFIER)));
        builder.add((Object)Pair.of((Object)((Object)Type.MAGIC_ABSORBTION), (Object)((Object)Type.MAGIC_INFUSER)));
        OPPOSITES = builder.build();
    }

    public static enum Type {
        CONTROLLER(TileTerraformer::new, new int[0]),
        ANTENNA(null),
        HUMIDIFIER(-16674305, -15829505, -15048961),
        DEHUMIDIFIER(-1571, -2888, -5514),
        HEATER(-11776, -26368, -38400),
        COOLER(-4336395, -7427371, -12820322),
        DEHOSTILIFIER(-3542029, -5846326, -8545895, -9599354, -131160),
        MAGIC_ABSORBTION(-3473201, 14549162, -393098),
        MAGIC_INFUSER(-589601, -2096919, -5111553),
        CLIMOGRAPH_BASE(null);

        @Nullable
        public final Supplier<? extends XUTile> te;
        public final int[] colors;

        private Type(int ... colors) {
            this(TileTerraformerClimograph::new, colors);
        }

        private Type(Supplier<? extends XUTile> te, int ... colors) {
            this.te = te;
            this.colors = colors;
        }
    }
}

